/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import io.papermc.paper.persistence.PersistentDataContainerView;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.items.ItemBuilder;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.PanelSession;
import me.rockyhawk.commandpanels.session.PanelUpdater;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryPanelUpdater
implements PanelUpdater {
    private BukkitRunnable task;

    @Override
    public void start(final Context ctx, final PanelSession session) {
        Panel panel = session.getPanel();
        if (!(panel instanceof InventoryPanel)) {
            return;
        }
        final InventoryPanel panel2 = (InventoryPanel)panel;
        this.stop();
        InventoryPanelBuilder panelBuilder = new InventoryPanelBuilder(ctx, session.getPlayer());
        final ItemBuilder builder = new ItemBuilder(ctx, panelBuilder);
        int updateDelay = 20;
        if (panel2.getUpdateDelay().matches("\\d+")) {
            updateDelay = Integer.parseInt(panel2.getUpdateDelay());
        }
        if (updateDelay == 0) {
            this.task = null;
            return;
        }
        this.task = new BukkitRunnable(this){

            public void run() {
                Inventory inv = session.getPlayer().getOpenInventory().getTopInventory();
                NamespacedKey itemIdKey = new NamespacedKey((Plugin)ctx.plugin, "item_id");
                NamespacedKey baseIdKey = new NamespacedKey((Plugin)ctx.plugin, "base_item_id");
                NamespacedKey fillItem = new NamespacedKey((Plugin)ctx.plugin, "fill_item");
                for (int slot = 0; slot < inv.getSize(); ++slot) {
                    PersistentDataContainerView container;
                    ItemStack item = inv.getItem(slot);
                    if (item == null || item.getType().isAir() || !(container = item.getPersistentDataContainer()).has(itemIdKey, PersistentDataType.STRING) || container.has(fillItem, PersistentDataType.STRING)) continue;
                    String itemId = (String)container.get(itemIdKey, PersistentDataType.STRING);
                    String baseItemId = (String)container.get(baseIdKey, PersistentDataType.STRING);
                    PanelItem panelItem = panel2.getItems().get(itemId);
                    if (!panelItem.animate().isEmpty()) {
                        PanelItem animateItem = panel2.getItems().get(panelItem.animate());
                        if (animateItem != null) {
                            panelItem = animateItem;
                        }
                    } else if (!baseItemId.equals(itemId)) {
                        panelItem = panel2.getItems().get(baseItemId);
                    }
                    ItemStack newItem = builder.buildItem(panel2, panelItem);
                    newItem.editPersistentDataContainer(c -> c.set(baseIdKey, PersistentDataType.STRING, (Object)baseItemId));
                    inv.setItem(slot, newItem);
                }
            }
        };
        this.task.runTaskTimer((Plugin)ctx.plugin, (long)updateDelay, (long)updateDelay);
    }

    @Override
    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }
}

