/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.floodgate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.floodgate.FloodgatePanelBuilder;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.SessionManager;
import me.rockyhawk.commandpanels.session.floodgate.FloodgateComponent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class FloodgatePanel
extends Panel {
    private final String simpleSubtitle;
    private final String floodgateType;
    private final Map<String, FloodgateComponent> components = new HashMap<String, FloodgateComponent>();
    private final Map<String, List<String>> order = new HashMap<String, List<String>>();

    public FloodgatePanel(String name, YamlConfiguration config) {
        super(name, config);
        ConfigurationSection componentSection;
        this.simpleSubtitle = config.getString("subtitle", "");
        this.floodgateType = config.getString("floodgate-type", "simple");
        ConfigurationSection orderSection = config.getConfigurationSection("layout");
        if (orderSection != null) {
            for (String key : orderSection.getKeys(false)) {
                this.order.put(key, orderSection.getStringList(key));
            }
        }
        if ((componentSection = config.getConfigurationSection("items")) != null) {
            for (String key : componentSection.getKeys(false)) {
                FloodgateComponent component;
                ConfigurationSection configSection = componentSection.getConfigurationSection(key);
                if (configSection == null || (component = FloodgateComponent.fromSection(key, configSection)) == null) continue;
                this.components.put(component.getId(), component);
            }
        }
    }

    @Override
    public void open(Context ctx, Player player, SessionManager.PanelOpenType openType) {
        if (Bukkit.getPluginManager().getPlugin("floodgate") == null) {
            return;
        }
        if (openType != SessionManager.PanelOpenType.REFRESH) {
            CommandRunner runner = new CommandRunner(ctx);
            runner.runCommands(this, player, this.getCommands());
        }
        FloodgatePanelBuilder builder = new FloodgatePanelBuilder(ctx, player);
        ((PanelBuilder)builder).open(this, openType);
    }

    public String getSubtitle() {
        return this.simpleSubtitle;
    }

    public String getFloodgateType() {
        return this.floodgateType;
    }

    public Map<String, FloodgateComponent> getComponents() {
        return this.components;
    }

    public Map<String, List<String>> getOrder() {
        return this.order;
    }
}

