/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.PanelSession;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanelUpdater;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class SessionManager
implements Listener {
    private final Context ctx;
    private final Map<UUID, PanelSession> panelSessions = new HashMap<UUID, PanelSession>();

    public SessionManager(Context ctx) {
        this.ctx = ctx;
    }

    public PanelSession getPlayerSession(Player player) {
        return this.panelSessions.get(player.getUniqueId());
    }

    public void updateSession(Player player, Panel panel, PanelOpenType openType) {
        UUID uuid = player.getUniqueId();
        boolean panelSnooper = this.ctx.fileHandler.config.getBoolean("panel-snooper");
        this.panelSessions.compute(uuid, (key, session) -> {
            if (session == null) {
                session = new PanelSession(panel, player);
            } else {
                session.setPanel(panel);
            }
            if (panelSnooper && panel != null) {
                this.ctx.text.sendInfo((Audience)Bukkit.getConsoleSender(), Message.PANEL_OPEN_LOG, player.getName(), panel.getName());
            }
            this.ctx.dataLoader.saveDataFileAsync();
            if (panel instanceof InventoryPanel) {
                InventoryPanelUpdater updater = new InventoryPanelUpdater();
                session.startUpdateTask(this.ctx, updater);
            }
            return session;
        });
    }

    public void removeSession(Player player) {
        this.panelSessions.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.ctx.session.updateSession(e.getPlayer(), null, PanelOpenType.EXTERNAL);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.ctx.session.removeSession(e.getPlayer());
    }

    public static enum PanelOpenType {
        EXTERNAL,
        INTERNAL,
        REFRESH;

    }
}

