/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session;

import java.util.HashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.PanelUpdater;
import org.bukkit.entity.Player;

public class PanelSession {
    private Panel panel;
    private Panel previous;
    private final Player player;
    private final Map<String, String> data;
    private PanelUpdater updater;

    public PanelSession(Panel panel, Player player) {
        this.panel = panel;
        this.previous = null;
        this.player = player;
        this.data = new HashMap<String, String>();
    }

    public Panel getPanel() {
        return this.panel;
    }

    public void setPanel(Panel panel) {
        if (this.panel == null) {
            this.panel = panel;
            return;
        }
        if (!panel.getName().equals(this.panel.getName())) {
            this.previous = this.panel;
        }
        this.panel = panel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void startUpdateTask(Context ctx, PanelUpdater updater) {
        this.removeUpdateTask();
        this.updater = updater;
        updater.start(ctx, this);
    }

    public void removeUpdateTask() {
        if (this.updater != null) {
            this.updater.stop();
            this.updater = null;
        }
    }

    public void setData(String key, String value) {
        this.data.put(key, value);
    }

    public String getData(String key) {
        return this.data.get(key);
    }

    public void removeData(String key) {
        this.data.remove(key);
    }

    public void clearData() {
        this.data.clear();
    }

    public Panel getPrevious() {
        return this.previous;
    }
}

