/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.interaction.commands.tags.ChatTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ClosePanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ConsoleCmdTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.GiveTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.GrantTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ItemActionTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.MessageTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.OpenPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.PreviousPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.RefreshPanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ServerTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SessionTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SoundTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.StopSoundTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.TeleportTag;
import me.rockyhawk.commandpanels.session.Panel;
import org.bukkit.entity.Player;

public class CommandRunner {
    private final Context ctx;
    private final List<CommandTagResolver> resolvers = new ArrayList<CommandTagResolver>();

    public CommandRunner(Context pl) {
        this.ctx = pl;
        this.registerResolvers();
    }

    private void registerResolvers() {
        this.resolvers.add(new OpenPanelTag());
        this.resolvers.add(new RefreshPanelTag());
        this.resolvers.add(new PreviousPanelTag());
        this.resolvers.add(new ClosePanelTag());
        this.resolvers.add(new ConsoleCmdTag());
        this.resolvers.add(new SessionTag());
        this.resolvers.add(new DataTag());
        this.resolvers.add(new ChatTag());
        this.resolvers.add(new GrantTag());
        this.resolvers.add(new ServerTag());
        this.resolvers.add(new MessageTag());
        this.resolvers.add(new GiveTag());
        this.resolvers.add(new ItemActionTag());
        this.resolvers.add(new SoundTag());
        this.resolvers.add(new StopSoundTag());
        this.resolvers.add(new TeleportTag());
    }

    public void runCommands(Panel panel, Player player, List<String> commands) {
        for (String command : commands) {
            this.runCommand(panel, player, command);
        }
    }

    public void runCommand(Panel panel, Player player, String command) {
        for (CommandTagResolver resolver : this.resolvers) {
            if (command.isEmpty()) {
                return;
            }
            String[] parts = command.split("\\s+", 2);
            String tag = parts[0];
            String args = parts.length > 1 ? parts[1].trim() : "";
            String argsParsed = this.ctx.text.parseTextToString(player, args);
            if (!resolver.isCorrectTag(tag)) continue;
            resolver.handle(this.ctx, panel, player, args, argsParsed);
            return;
        }
    }
}

