/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.language;

import java.util.Objects;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.LanguageManager;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class TextFormatter {
    public final LanguageManager lang;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();

    public TextFormatter(Context ctx) {
        this.lang = new LanguageManager(ctx);
    }

    public TextComponent getPrefix() {
        String translatedPrefix = this.lang.translate(Message.PREFIX, new Object[0]) + " ";
        if (Objects.equals(translatedPrefix, "[CommandPanels] ")) {
            return (TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"CommandPanels", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GOLD));
        }
        return (TextComponent)this.deserializeAppropriately(translatedPrefix);
    }

    private Component buildLocalizedComponent(String translatedMessage, NamedTextColor defaultColor) {
        if (translatedMessage == null || translatedMessage.isEmpty()) {
            return Component.empty();
        }
        Component parsed = this.deserializeAppropriately(translatedMessage);
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)defaultColor)).append(parsed)).build();
    }

    public void sendInfo(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.WHITE);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendWarn(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.YELLOW);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendError(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.RED);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendHelp(Audience audience, Message command, Message description, Object ... args) {
        String translatedCommand = this.lang.translate(command, args);
        String translatedDescription = this.lang.translate(description, args);
        Component cmdComp = this.buildLocalizedComponent(translatedCommand, NamedTextColor.GOLD);
        Component descComp = this.buildLocalizedComponent(translatedDescription, NamedTextColor.WHITE);
        Component space = Component.text((String)" ").color((TextColor)NamedTextColor.WHITE);
        BuildableComponent helpComp = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(cmdComp)).append(space)).append(descComp)).build();
        audience.sendMessage((Component)helpComp);
    }

    @NotNull
    public Component parseTextToComponent(Player player, String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        input = this.applyPlaceholders(player, input);
        return this.deserializeAppropriately(input);
    }

    @Subst(value="")
    @NotNull
    public String parseTextToString(Player player, String input) {
        Component component = this.parseTextToComponent(player, input);
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public String applyPlaceholders(Player player, String input) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)player.getUniqueId());
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)input);
        }
        return input;
    }

    private Component deserializeAppropriately(String input) {
        try {
            Component mmComponent = this.miniMessage.deserialize((Object)input);
            TextComponent plain = Component.text((String)input);
            if (mmComponent.equals((Object)plain)) {
                return this.legacySerializer.deserialize(input.replaceAll("(?i)&([0-9a-fk-or])", "\u00a7$1")).decoration(TextDecoration.ITALIC, false);
            }
            if (mmComponent.decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
                mmComponent = mmComponent.decoration(TextDecoration.ITALIC, false);
            }
            return mmComponent;
        }
        catch (Exception e) {
            return Component.text((String)input).decoration(TextDecoration.ITALIC, false);
        }
    }
}

