/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.data;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.data.DataManager;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DataLoader {
    Context ctx;
    public YamlConfiguration dataConfig;
    public DataManager dataPlayers = new DataManager(this);

    public DataLoader(Context pl) {
        this.ctx = pl;
        this.dataConfig = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder(), "data.yml"));
    }

    public String getUserData(String playerName, String dataPoint) {
        return this.dataConfig.getString(this.dataPlayers.getDataProfile(playerName) + ".data." + dataPoint);
    }

    public void setUserData(String playerName, String dataPoint, String dataValue, boolean overwrite) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        if (!overwrite && this.dataConfig.isSet(profile + ".data." + dataPoint)) {
            return;
        }
        this.dataConfig.set(profile + ".data." + dataPoint, (Object)dataValue);
    }

    public void delUserData(String playerName, String dataPoint) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        this.dataConfig.set(profile + ".data." + dataPoint, null);
    }

    public void clearData(String playerName) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        this.dataConfig.set(profile, null);
    }

    public void saveDataFileSync() {
        try {
            File file = new File(this.ctx.plugin.getDataFolder(), "data.yml");
            this.dataConfig.save(file);
        }
        catch (IOException e) {
            Bukkit.getScheduler().runTask((Plugin)this.ctx.plugin, () -> this.ctx.text.sendError((Audience)Bukkit.getConsoleSender(), Message.FILE_SAVE_DATA_FAIL, new Object[0]));
        }
    }

    public void saveDataFileAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.ctx.plugin, this::saveDataFileSync);
    }

    public void doDataMath(String playerName, String dataPoint, String dataValue) {
        BigDecimal originalValue;
        String profile = this.dataPlayers.getDataProfile(playerName);
        try {
            originalValue = new BigDecimal(this.dataConfig.getString(profile + ".data." + dataPoint));
        }
        catch (Exception ex) {
            originalValue = new BigDecimal("1");
        }
        BigDecimal output = switch (dataValue.charAt(0)) {
            case '+' -> {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                yield originalValue.add(newValue);
            }
            case '-' -> {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                yield originalValue.subtract(newValue);
            }
            case '*' -> {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                yield originalValue.multiply(newValue);
            }
            case '/' -> {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                try {
                    yield originalValue.divide(newValue);
                }
                catch (ArithmeticException ex) {
                    yield originalValue;
                }
            }
            default -> originalValue;
        };
        if (output.stripTrailingZeros().scale() <= 0) {
            this.dataConfig.set(profile + ".data." + dataPoint, (Object)output.stripTrailingZeros().toPlainString());
            return;
        }
        this.dataConfig.set(profile + ".data." + dataPoint, (Object)output.toPlainString());
    }
}

