/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.inventory;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.TitleHandler;
import me.rockyhawk.commandpanels.builder.inventory.items.ItemBuilder;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PanelFactory {
    protected final Context ctx;
    protected final InventoryPanelBuilder panelBuilder;

    public PanelFactory(Context ctx, InventoryPanelBuilder builder) {
        this.ctx = ctx;
        this.panelBuilder = builder;
    }

    public Inventory createInventory(InventoryPanel panel, Player p) {
        Inventory inv;
        TitleHandler titleHandler = new TitleHandler();
        Component title = titleHandler.getTitle(this.ctx, panel, p);
        String rows = this.ctx.text.parseTextToString(p, panel.getRows());
        if (rows.matches("\\d+")) {
            int rowsNum = Integer.parseInt(rows);
            if (rowsNum > 6) {
                rowsNum = 6;
            }
            inv = Bukkit.createInventory((InventoryHolder)p, (int)(rowsNum * 9), (Component)title);
        } else {
            try {
                inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.valueOf((String)rows.toUpperCase()), (Component)title);
            }
            catch (IllegalArgumentException e) {
                this.ctx.text.sendError((Audience)p, Message.PANEL_INVALID_TYPE, new Object[0]);
                inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (Component)title);
            }
        }
        ItemStack fill = null;
        ItemBuilder itemBuilder = new ItemBuilder(this.ctx, this.panelBuilder);
        for (String slot : panel.getSlots().keySet()) {
            int slotIndex;
            String parsedSlot = this.ctx.text.parseTextToString(p, slot);
            ItemStack itemStack = new ItemStack(Material.AIR);
            for (String name : panel.getSlots().get(slot)) {
                ConditionNode conditionNode;
                boolean result;
                PanelItem item = panel.getItems().get(name);
                if (item == null || !item.conditions().trim().isEmpty() && !(result = (conditionNode = new ConditionParser().parse(item.conditions())).evaluate(p, this.ctx))) continue;
                itemStack = itemBuilder.buildItem(panel, item);
                break;
            }
            if (parsedSlot.equalsIgnoreCase("fill")) {
                fill = itemStack;
                continue;
            }
            if (!slot.matches("\\d+") || (slotIndex = Integer.parseInt(parsedSlot)) < 0 || slotIndex >= inv.getSize()) continue;
            inv.setItem(slotIndex, itemStack);
        }
        if (fill != null) {
            TooltipDisplay tooltipHidden = (TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build();
            fill.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)tooltipHidden);
            NamespacedKey filler = new NamespacedKey((Plugin)this.ctx.plugin, "fill_item");
            fill.editPersistentDataContainer(c -> c.set(filler, PersistentDataType.STRING, (Object)"true"));
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack current = inv.getItem(i);
                if (current != null && current.getType() != Material.AIR) continue;
                inv.setItem(i, fill);
            }
        }
        return inv;
    }
}

