/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.bootstrap.Environment;

public class JARLibraryLoader
extends URLClassLoader {
    private static JARLibraryLoader instance = new JARLibraryLoader();
    private static final List<String> EDITIONS = Arrays.asList("Free", "Premium", "Private");

    private JARLibraryLoader() {
        super(new URL[0], JARLibraryLoader.class.getClassLoader());
    }

    void open(Environment environment, Object ... args) {
        try {
            Path dataFolder = (Path)args[1];
            Path files = dataFolder.resolve("files");
            List<URL> jars = this.getJARs();
            if (Files.exists(files, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(files);){
                    for (Path file : stream) {
                        if (!file.getFileName().toString().endsWith(".jar.tmp")) continue;
                        Files.delete(file);
                    }
                }
            } else if (!Files.exists(dataFolder, new LinkOption[0])) {
                Object logger = args[0];
                logger.getClass().getMethod(logger instanceof Logger ? "warning" : "warn", String.class).invoke(logger, "Fresh installation? Welcome! Generating default files for you. Follow this guide for proper installation: https://remigio07.me/chatplugin/wiki/getting-started/Installation");
                Files.createDirectories(files, new FileAttribute[0]);
            } else {
                Files.createDirectory(files, new FileAttribute[0]);
            }
            for (int i = 0; i < jars.size(); ++i) {
                URL jar = jars.get(i);
                try (InputStream input = jar.openStream();){
                    Path path = Files.createTempFile(files, EDITIONS.get(i).toLowerCase() + "-", ".jar.tmp", new FileAttribute[0]);
                    Files.copy(input, path, StandardCopyOption.REPLACE_EXISTING);
                    path.toFile().deleteOnExit();
                    this.addURL(path.toUri().toURL());
                    continue;
                }
            }
            Class.forName("me.remigio07.chatplugin.ChatPlugin" + EDITIONS.get(jars.size() - 1), true, this).getMethod("load", Object.class, Path.class, Object.class).invoke(null, args);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private List<URL> getJARs() {
        return EDITIONS.stream().map(edition -> this.getClass().getClassLoader().getResource("ChatPlugin-" + edition.toUpperCase() + ".jar")).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void load(Path library) throws IOException {
        this.addURL(library.toUri().toURL());
    }

    public static JARLibraryLoader getInstance() {
        return instance;
    }

    static {
        JARLibraryLoader.registerAsParallelCapable();
    }
}

