/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.ServerInformation;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.packet.PacketSerializer;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public abstract class ProxyManager
implements ChatPluginManager {
    public static final String DEFAULT_SERVER_ID = "default-server-id";
    public static final Pattern SERVER_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static ProxyManager instance;
    protected boolean enabled;
    protected String serverID;
    protected String serverDisplayName;
    protected List<String> logFilteredPackets = Collections.emptyList();
    protected Map<String, ServerInformation> serversInformation = new ConcurrentHashMap<String, ServerInformation>();
    protected long[] taskIDs = new long[2];
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getServerID() {
        return this.serverID;
    }

    public String getServerDisplayName() {
        return this.serverDisplayName;
    }

    public List<String> getLogFilteredPackets() {
        return this.logFilteredPackets;
    }

    public Map<String, ServerInformation> getServersInformation() {
        return this.serversInformation;
    }

    public List<String> getServersIDs() {
        return new ArrayList<String>(this.serversInformation.keySet());
    }

    public int getOnlinePlayers(String server, boolean hideVanished) {
        if (server.equals("ALL")) {
            int total = 0;
            for (ServerInformation info : this.serversInformation.values()) {
                total += info.getOnlinePlayers() - (hideVanished ? info.getVanishedPlayers() : 0);
            }
            return total;
        }
        return this.serversInformation.containsKey(server) ? this.serversInformation.get(server).getOnlinePlayers() - (hideVanished ? this.serversInformation.get(server).getVanishedPlayers() : 0) : 0;
    }

    public int getVanishedPlayers(String server) {
        if (server.equals("ALL")) {
            int total = 0;
            for (ServerInformation info : this.serversInformation.values()) {
                total += info.getVanishedPlayers();
            }
            return total;
        }
        return this.serversInformation.containsKey(server) ? this.serversInformation.get(server).getVanishedPlayers() : 0;
    }

    public String formatOnlineAndVanishedPlaceholders(String input, boolean hideVanished) {
        for (ServerInformation info : this.serversInformation.values()) {
            input = input.replace("{online@" + info.getID() + "}", String.valueOf(info.getOnlinePlayers() - (hideVanished ? info.getVanishedPlayers() : 0))).replace("{vanished@" + info.getID() + "}", String.valueOf(info.getVanishedPlayers()));
        }
        return input;
    }

    public boolean isValidServerID(String serverID) {
        return serverID.equalsIgnoreCase("proxy") || serverID.equalsIgnoreCase("all") ? false : SERVER_ID_PATTERN.matcher(serverID).matches();
    }

    public static ProxyManager getInstance() {
        return instance;
    }

    public void sendPluginMessage(PacketSerializer packet) {
        throw new UnsupportedOperationException("Unable to send a plugin message on the free version");
    }

    public void receivePluginMessage(byte[] message) {
        throw new UnsupportedOperationException("Unable to receive a plugin message on the free version");
    }

    public void connect(ChatPluginServerPlayer player, String server) {
        throw new UnsupportedOperationException("Unable to connect a player to another server on the free version");
    }
}

