/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

public abstract class PlaceholderManager
implements ChatPluginManager,
Runnable {
    protected static PlaceholderManager instance;
    protected boolean enabled;
    protected long timerTaskID = -1L;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public String translatePlaceholders(String input, ChatPluginServerPlayer player, Set<PlaceholderType> placeholderTypes) {
        return this.translatePlaceholders(input, player, player.getLanguage(), placeholderTypes);
    }

    public String translatePlaceholders(String input, ChatPluginServerPlayer player, Language language, Set<PlaceholderType> placeholderTypes) {
        return this.translatePlaceholders(input, player, language, placeholderTypes, true);
    }

    public List<String> translatePlaceholders(List<String> input, ChatPluginServerPlayer player, Set<PlaceholderType> placeholderTypes) {
        return this.translatePlaceholders(input, player, player.getLanguage(), placeholderTypes);
    }

    public List<String> translatePlaceholders(List<String> input, ChatPluginServerPlayer player, Language language, Set<PlaceholderType> placeholderTypes) {
        return input.stream().map(string -> this.translatePlaceholders((String)string, player, language, placeholderTypes)).collect(Collectors.toList());
    }

    public String translatePlayerPlaceholders(String input, ChatPluginServerPlayer player) {
        return this.translatePlayerPlaceholders(input, player, player.getLanguage());
    }

    public String translatePlayerPlaceholders(String input, ChatPluginServerPlayer player, Language language) {
        return this.translatePlayerPlaceholders(input, player, language, true);
    }

    public List<String> translatePlayerPlaceholders(List<String> input, ChatPluginServerPlayer player) {
        return this.translatePlayerPlaceholders(input, player, player.getLanguage());
    }

    public List<String> translatePlayerPlaceholders(List<String> input, ChatPluginServerPlayer player, Language language) {
        return input.stream().map(string -> this.translatePlayerPlaceholders((String)string, player, language)).collect(Collectors.toList());
    }

    public String translateServerPlaceholders(String input, Language language) {
        return this.translateServerPlaceholders(input, language, true);
    }

    public List<String> translateServerPlaceholders(List<String> input, Language language) {
        return input.stream().map(string -> this.translateServerPlaceholders((String)string, language)).collect(Collectors.toList());
    }

    public String translateIntegrationsPlaceholders(String input, ChatPluginServerPlayer player) {
        return this.translateIntegrationsPlaceholders(input, player, player.getLanguage());
    }

    public String translateIntegrationsPlaceholders(String input, ChatPluginServerPlayer player, Language language) {
        return this.translateIntegrationsPlaceholders(input, player, player.getLanguage(), true);
    }

    public List<String> translateIntegrationsPlaceholders(List<String> input, ChatPluginServerPlayer player) {
        return this.translateIntegrationsPlaceholders(input, player, player.getLanguage());
    }

    public List<String> translateIntegrationsPlaceholders(List<String> input, ChatPluginServerPlayer player, Language language) {
        return input.stream().map(string -> this.translateIntegrationsPlaceholders((String)string, player, language)).collect(Collectors.toList());
    }

    public static PlaceholderManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract String translatePlaceholders(String var1, ChatPluginServerPlayer var2, Language var3, Set<PlaceholderType> var4, boolean var5);

    public abstract String translatePlayerPlaceholders(String var1, ChatPluginServerPlayer var2, Language var3, boolean var4);

    public abstract String translateServerPlaceholders(String var1, Language var2, boolean var3);

    public abstract String translateIntegrationsPlaceholders(String var1, ChatPluginServerPlayer var2, Language var3, boolean var4);
}

