/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public abstract class PingManager
implements ChatPluginManager,
Runnable {
    public static final String[] PLACEHOLDERS = new String[]{"ping", "ping_format", "ping_quality_color", "ping_quality_text"};
    protected static PingManager instance;
    protected boolean enabled;
    protected List<PingQuality> qualities = new ArrayList<PingQuality>();
    protected long updateTimeout;
    protected long timerTaskID = -1L;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<PingQuality> getQualities() {
        return this.qualities;
    }

    public long getUpdateTimeout() {
        return this.updateTimeout;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public int getCachedPing(ChatPluginServerPlayer player) {
        return player.getPing();
    }

    public static PingManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    @Deprecated
    public abstract int getRealTimePing(ChatPluginServerPlayer var1);

    public abstract PingQuality getPingQuality(int var1);

    public abstract String formatPing(int var1, Language var2);

    public abstract String formatPlaceholders(String var1, int var2, Language var3);

    public abstract List<String> formatPlaceholders(List<String> var1, int var2, Language var3);

    public class PingQuality
    implements Comparable<PingQuality> {
        private String id;
        private int maximumPing;

        public PingQuality(String id, int maximumPing) {
            if (maximumPing < 0) {
                throw new IllegalArgumentException("Specified maximum ping is less than 0");
            }
            this.id = id;
            this.maximumPing = maximumPing;
        }

        @Override
        public int compareTo(PingQuality o) {
            return this.maximumPing < o.getMaximumPing() ? -1 : (this.maximumPing == o.getMaximumPing() ? 0 : 1);
        }

        public String toString() {
            return new StringJoiner(", ", "PingQuality{", "}").add("id=\"" + this.id + "\"").add("maximumPing=" + this.maximumPing).toString();
        }

        public String getID() {
            return this.id;
        }

        public int getMaximumPing() {
            return this.maximumPing;
        }

        public String getColor(Language language) {
            return language.getMessage("ping." + this.id + ".color", new Object[0]);
        }

        public String getText(Language language) {
            return language.getMessage("ping." + this.id + ".text", new Object[0]);
        }
    }
}

