/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.GameFeature;

@GameFeature(name="MSPT", paperRequired=true, minimumBukkitVersion=VersionUtils.Version.V1_16, minimumSpongeVersion=VersionUtils.Version.UNSUPPORTED, minimumFabricVersion=VersionUtils.Version.UNSUPPORTED)
public abstract class MSPTManager
implements ChatPluginManager,
Runnable {
    public static final String[] PLACEHOLDERS = new String[]{"mspt_5_sec_avg", "mspt_5_sec_min", "mspt_5_sec_max", "mspt_10_sec_avg", "mspt_10_sec_min", "mspt_10_sec_max", "mspt_1_min_avg", "mspt_1_min_min", "mspt_1_min_max", "mspt_5_sec_avg_format", "mspt_5_sec_min_format", "mspt_5_sec_max_format", "mspt_10_sec_avg_format", "mspt_10_sec_min_format", "mspt_10_sec_max_format", "mspt_1_min_avg_format", "mspt_1_min_min_format", "mspt_1_min_max_format"};
    protected static MSPTManager instance;
    protected boolean enabled;
    protected List<MSPTQuality> qualities = new CopyOnWriteArrayList<MSPTQuality>();
    protected double[] averageMSPT = this.array();
    protected double[] minimumMSPT = this.array();
    protected double[] maximumMSPT = this.array();
    protected long updateTimeout;
    protected long timerTaskID = -1L;
    protected long loadTime;

    protected double[] array() {
        return new double[]{0.0, 0.0, 0.0};
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<MSPTQuality> getQualities() {
        return this.qualities;
    }

    public double[] getAverageMSPT() {
        return this.averageMSPT;
    }

    public double[] getMinimumMSPT() {
        return this.minimumMSPT;
    }

    public double[] getMaximumMSPT() {
        return this.maximumMSPT;
    }

    public long getUpdateTimeout() {
        return this.updateTimeout;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public static MSPTManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract double getAverageMSPT(MSPTTimeInterval var1);

    public abstract double getMinimumMSPT(MSPTTimeInterval var1);

    public abstract double getMaximumMSPT(MSPTTimeInterval var1);

    public abstract MSPTQuality getMSPTQuality(double var1);

    public abstract String formatMSPT(double var1, Language var3);

    public abstract String formatAverageMSPT(MSPTTimeInterval var1, Language var2);

    public abstract String formatMinimumMSPT(MSPTTimeInterval var1, Language var2);

    public abstract String formatMaximumMSPT(MSPTTimeInterval var1, Language var2);

    public abstract String formatPlaceholders(String var1, Language var2);

    public abstract List<String> formatPlaceholders(List<String> var1, Language var2);

    public static enum MSPTTimeInterval {
        FIVE_SECONDS,
        TEN_SECONDS,
        ONE_MINUTE;

    }

    public class MSPTQuality
    implements Comparable<MSPTQuality> {
        private String id;
        private double maximumMSPT;

        public MSPTQuality(String id, double maximumMSPT) {
            if (maximumMSPT < 0.0) {
                throw new IllegalArgumentException("Specified maximum MSPT is less than 0");
            }
            this.id = id;
            this.maximumMSPT = maximumMSPT;
        }

        @Override
        public int compareTo(MSPTQuality o) {
            return this.maximumMSPT < o.getMaximumMSPT() ? -1 : (this.maximumMSPT == o.getMaximumMSPT() ? 0 : 1);
        }

        public String toString() {
            return new StringJoiner(", ", "MSPTQuality{", "}").add("id=\"" + this.id + "\"").add("maximumMSPT=" + this.maximumMSPT).toString();
        }

        public String getID() {
            return this.id;
        }

        public double getMaximumMSPT() {
            return this.maximumMSPT;
        }

        public String getColor(Language language) {
            return language.getMessage("mspt-qualities." + this.id, new Object[0]);
        }
    }
}

