/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.user;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;

public class SoundAdapter {
    public static final Pattern NEW_VANILLA_COMPLIANT_IDS = Pattern.compile("[a-z0-9/._-]");
    private String id;
    private float volume;
    private float pitch;

    public SoundAdapter(String id, float volume, float pitch) {
        this.id = id;
        float f = volume < 0.0f ? 0.0f : (this.volume = volume > 1.0f ? 1.0f : volume);
        this.pitch = pitch < 0.0f ? 0.0f : (pitch > 2.0f ? 2.0f : pitch);
    }

    public SoundAdapter(Configuration configuration, String path) {
        this(configuration.getString(path + ".id"), configuration.getFloat(path + ".volume", 1.0f), configuration.getFloat(path + ".pitch", 1.0f));
    }

    public String toString() {
        return new StringJoiner(", ", "SoundAdapter{", "}").add("id=\"" + this.id + "\"").add("volume=" + this.volume + "F").add("pitch=" + this.pitch + "F").toString();
    }

    public Object bukkitValue() {
        if (Environment.isBukkit()) {
            Object sound;
            block9: {
                sound = null;
                try {
                    if (this.id.equals(this.id.toUpperCase())) {
                        sound = Class.forName("org.bukkit.Sound").getMethod("valueOf", String.class).invoke(null, this.id);
                    }
                    if (sound != null) break block9;
                    if (this.id.startsWith("minecraft:")) {
                        this.id = this.id.substring(10);
                    }
                    if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_16_4)) {
                        sound = Registry.SOUNDS.get(NamespacedKey.minecraft((String)this.id));
                        break block9;
                    }
                    if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9)) {
                        Class<?> CraftSound = Class.forName("org.bukkit.craftbukkit." + VersionUtils.getNMSVersion() + ".CraftSound");
                        Field minecraftKey = CraftSound.getDeclaredField("minecraftKey");
                        minecraftKey.setAccessible(true);
                        for (Object craftSound : (Object[])CraftSound.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                            if (!minecraftKey.get(craftSound).equals(this.id)) continue;
                            sound = Class.forName("org.bukkit.Sound").getMethod("valueOf", String.class).invoke(null, ((Enum)craftSound).name());
                            break block9;
                        }
                        break block9;
                    }
                    Field sounds = Class.forName("org.bukkit.craftbukkit." + VersionUtils.getNMSVersion() + ".CraftSound").getDeclaredField("sounds");
                    sounds.setAccessible(true);
                    int index = Utils.arrayIndexOf((String[])sounds.get(null), this.id, false);
                    if (index != -1) {
                        sound = ((Object[])Class.forName("org.bukkit.Sound").getMethod("values", new Class[0]).invoke(null, new Object[0]))[index];
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return sound;
        }
        throw new UnsupportedOperationException("Unable to adapt sound to a Bukkit's Sound on a " + Environment.getCurrent().getName() + " environment");
    }

    public SoundType spongeValue(boolean warnIfInvalid) {
        if (Environment.isSponge()) {
            SoundType sound = null;
            try {
                if (this.id.equals(this.id.toUpperCase())) {
                    sound = (SoundType)SoundTypes.class.getField(this.id).get(null);
                }
                if (sound == null) {
                    sound = Sponge.getRegistry().getType(SoundType.class, this.id).orElse(null);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                // empty catch block
            }
            if (warnIfInvalid && sound == null) {
                LogManager.log("Unknown sound ID: {0}.", 1, this.id);
            }
            return sound;
        }
        throw new UnsupportedOperationException("Unable to adapt sound to a Sponge's SoundType on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_3414 fabricValue(boolean warnIfInvalid) {
        if (Environment.isFabric()) {
            Object sound = null;
            try {
                if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_19_3)) {
                    if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_2)) {
                        if (this.id.equals(this.id.toUpperCase())) {
                            String[] parts;
                            String lowerCase = this.id.toLowerCase();
                            sound = class_7923.field_41172.method_63535(class_2960.method_60656((String)this.id.toLowerCase().replace('_', '.')));
                            if (sound == null && (parts = lowerCase.split("_")).length > 1) {
                                for (int i = 1; i < 1 << parts.length - 1 && (sound = class_7923.field_41172.method_63535(class_2960.method_60656((String)this.getCombination(parts, i)))) == null; ++i) {
                                }
                            }
                        }
                        if (sound == null) {
                            sound = class_7923.field_41172.method_63535(this.id.contains(":") ? class_2960.method_60654((String)this.id) : class_2960.method_60656((String)this.id));
                        }
                    } else {
                        Method get = class_2378.class.getMethod("method_10223", class_2960.class);
                        if (this.id.equals(this.id.toUpperCase())) {
                            String[] parts;
                            String lowerCase = this.id.toLowerCase();
                            sound = get.invoke((Object)class_7923.field_41172, class_2960.method_43902((String)"minecraft", (String)this.id.toLowerCase().replace('_', '.')));
                            if (sound == null && (parts = lowerCase.split("_")).length > 1) {
                                for (int i = 1; i < 1 << parts.length - 1 && (sound = get.invoke((Object)class_7923.field_41172, class_2960.method_43902((String)"minecraft", (String)this.getCombination(parts, i)))) == null; ++i) {
                                }
                            }
                        }
                        if (sound == null) {
                            sound = get.invoke((Object)class_7923.field_41172, this.id.contains(":") ? class_2960.method_12829((String)this.id) : class_2960.method_43902((String)"minecraft", (String)this.id));
                        }
                    }
                } else {
                    Method get = class_2378.class.getMethod("method_10223", class_2960.class);
                    Object SOUND_EVENT = class_2378.class.getField("field_11156").get(null);
                    if (this.id.equals(this.id.toUpperCase())) {
                        String[] parts;
                        String lowerCase = this.id.toLowerCase();
                        sound = get.invoke(SOUND_EVENT, class_2960.method_12829((String)("minecraft:" + this.id.toLowerCase().replace('_', '.'))));
                        if (sound == null && (parts = lowerCase.split("_")).length > 1) {
                            for (int i = 1; i < 1 << parts.length - 1 && (sound = get.invoke(SOUND_EVENT, class_2960.method_12829((String)("minecraft:" + this.getCombination(parts, i))))) == null; ++i) {
                            }
                        }
                    }
                    if (sound == null) {
                        sound = get.invoke(SOUND_EVENT, this.id.contains(":") ? class_2960.method_12829((String)this.id) : class_2960.method_12829((String)("minecraft:" + this.id)));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (warnIfInvalid && sound == null) {
                LogManager.log("Unknown sound ID: {0}.", 1, this.id);
            }
            return (class_3414)sound;
        }
        throw new UnsupportedOperationException("Unable to adapt sound to a Fabric's SoundEvent on a " + Environment.getCurrent().getName() + " environment");
    }

    private String getCombination(String[] parts, int index) {
        StringBuilder sb = new StringBuilder(parts[0]);
        for (int i = 0; i < parts.length - 1; ++i) {
            sb.append((index >> i & 1) == 0 ? (char)'.' : '_');
            sb.append(parts[i + 1]);
        }
        return sb.toString();
    }

    public String getID() {
        return this.id;
    }

    public boolean isVanillaCompliant() {
        return VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_13) || NEW_VANILLA_COMPLIANT_IDS.matcher(this.id).matches();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

