/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.user;

import java.lang.reflect.InvocationTargetException;
import java.util.StringJoiner;
import java.util.UUID;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.player.ServerPlayerManager;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

public class CommandSenderAdapter {
    public static final CommandSenderAdapter CONSOLE = new CommandSenderAdapter(Environment.isBukkit() ? Bukkit.getConsoleSender() : (Environment.isSponge() ? Sponge.getServer().getConsole() : FabricBootstrapper.getInstance().getServer().method_3739()));
    private Object commandSender;

    public CommandSenderAdapter(Object commandSender) {
        this.commandSender = commandSender;
    }

    public int hashCode() {
        return this.commandSender.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CommandSenderAdapter ? ((CommandSenderAdapter)obj).commandSender.equals(this.commandSender) : false;
    }

    public String toString() {
        return new StringJoiner(", ", "CommandSenderAdapter{", "}").add("uuid=" + this.getUUID().toString()).add("name=\"" + this.getName() + "\"").add("isConsole=" + this.isConsole()).toString();
    }

    public CommandSender bukkitValue() {
        if (Environment.isBukkit()) {
            return (CommandSender)this.commandSender;
        }
        throw new UnsupportedOperationException("Unable to adapt command sender to a Bukkit's CommandSender on a " + Environment.getCurrent().getName() + " environment");
    }

    public CommandSource spongeValue() {
        if (Environment.isSponge()) {
            return (CommandSource)this.commandSender;
        }
        throw new UnsupportedOperationException("Unable to adapt command sender to a Sponge's CommandSource on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_2168 fabricValue() {
        if (Environment.isFabric()) {
            return (class_2168)this.commandSender;
        }
        throw new UnsupportedOperationException("Unable to adapt command sender to a Fabric's ServerCommandSource on a " + Environment.getCurrent().getName() + " environment");
    }

    public boolean isConsole() {
        return this.getName().equals("@") || (Environment.isFabric() ? !(this.fabricValue().method_9228() instanceof class_3222) : CONSOLE.equals(this));
    }

    public boolean isPlayer() {
        return !this.isConsole();
    }

    public boolean isLoaded() {
        return this.toServerPlayer() != null;
    }

    public String getName() {
        return Environment.isBukkit() ? this.bukkitValue().getName() : (Environment.isSponge() ? this.spongeValue().getName() : this.fabricValue().method_9214());
    }

    public UUID getUUID() {
        return this.isConsole() ? null : (Environment.isBukkit() ? ((org.bukkit.entity.Player)this.bukkitValue()).getUniqueId() : (Environment.isSponge() ? ((Player)this.spongeValue()).getUniqueId() : this.fabricValue().method_9228().method_5667()));
    }

    public boolean hasPermission(String permission) {
        return Environment.isBukkit() ? this.bukkitValue().hasPermission(permission) : (Environment.isSponge() ? this.spongeValue().hasPermission(permission) : this.isConsole() || new PlayerAdapter(this.fabricValue().method_9228()).hasPermission(permission));
    }

    public void sendMessage(String message) {
        if (Environment.isBukkit()) {
            this.bukkitValue().sendMessage(message);
        } else if (Environment.isSponge()) {
            this.spongeValue().sendMessage(Utils.toSpongeComponent(message));
        } else {
            try {
                Class.forName("me.remigio07.chatplugin.server.fabric.ChatPluginFabric", false, JARLibraryLoader.getInstance()).getMethod("sendMessage", class_2168.class, class_2561.class).invoke(null, this.fabricValue(), Utils.toFabricComponent(message));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public ChatPluginServerPlayer toServerPlayer() {
        return this.isConsole() ? null : ServerPlayerManager.getInstance().getPlayer(this.getUUID());
    }
}

