/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.scoreboard;

import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_268;
import org.bukkit.scoreboard.Team;

public class TeamAdapter {
    private Object team;

    public TeamAdapter(Object team) {
        this.team = team;
    }

    public Team bukkitValue() {
        if (Environment.isBukkit()) {
            return (Team)this.team;
        }
        throw new UnsupportedOperationException("Unable to adapt team to a Bukkit's Team on a " + Environment.getCurrent().getName() + " environment");
    }

    public org.spongepowered.api.scoreboard.Team spongeValue() {
        if (Environment.isSponge()) {
            return (org.spongepowered.api.scoreboard.Team)this.team;
        }
        throw new UnsupportedOperationException("Unable to adapt team to a Sponge's Team on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_268 fabricValue() {
        if (Environment.isFabric()) {
            return (class_268)this.team;
        }
        throw new UnsupportedOperationException("Unable to adapt team to a Fabric's Team on a " + Environment.getCurrent().getName() + " environment");
    }

    public String getName() {
        return Environment.isBukkit() ? this.bukkitValue().getName() : (Environment.isSponge() ? this.spongeValue().getName() : this.fabricValue().method_1197());
    }

    public String getPrefix() {
        return Environment.isBukkit() ? this.bukkitValue().getPrefix() : (Environment.isSponge() ? Utils.toLegacyText(this.spongeValue().getPrefix()) : Utils.toLegacyText(this.fabricValue().method_1144()));
    }

    public String getSuffix() {
        return Environment.isBukkit() ? this.bukkitValue().getSuffix() : (Environment.isSponge() ? Utils.toLegacyText(this.spongeValue().getSuffix()) : Utils.toLegacyText(this.fabricValue().method_1136()));
    }

    public void setPrefix(String prefix) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setPrefix(prefix);
        } else if (Environment.isSponge()) {
            this.spongeValue().setPrefix(Utils.toSpongeComponent(prefix));
        } else {
            this.fabricValue().method_1138(Utils.toFabricComponent(prefix));
        }
    }

    public void setSuffix(String suffix) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setSuffix(suffix);
        } else if (Environment.isSponge()) {
            this.spongeValue().setSuffix(Utils.toSpongeComponent(suffix));
        } else {
            this.fabricValue().method_1139(Utils.toFabricComponent(suffix));
        }
    }
}

