/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.inventory;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.player.ServerPlayerManager;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemStackAdapter;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.SpongeBootstrapper;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import org.bukkit.Bukkit;
import org.bukkit.entity.AnimalTamer;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

public class InventoryAdapter {
    private ItemStackAdapter[] items;
    private Object inventory;
    private int size;
    private String title;

    public InventoryAdapter(int rows, String title) {
        if (rows < 1 || rows > 6) {
            throw new IndexOutOfBoundsException("Specified inventory's rows (" + rows + ") are invalid as they are not inside of range 1-6");
        }
        this.size = rows * 9;
        this.title = title;
        this.inventory = Environment.isBukkit() ? Bukkit.createInventory(null, (int)this.size, (String)title) : (Environment.isSponge() ? SpongeInventory.get(rows, title) : new class_1277(this.size));
        this.items = new ItemStackAdapter[this.size];
    }

    public org.bukkit.inventory.Inventory bukkitValue() {
        if (Environment.isBukkit()) {
            return (org.bukkit.inventory.Inventory)this.inventory;
        }
        throw new UnsupportedOperationException("Unable to adapt inventory to a Bukkit's Inventory on a " + Environment.getCurrent().getName() + " environment");
    }

    public Inventory spongeValue() {
        if (Environment.isSponge()) {
            return (Inventory)this.inventory;
        }
        throw new UnsupportedOperationException("Unable to adapt inventory to a Sponge's Inventory on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1277 fabricValue() {
        if (Environment.isFabric()) {
            return (class_1277)this.inventory;
        }
        throw new UnsupportedOperationException("Unable to adapt inventory to a Fabric's SimpleInventory on a " + Environment.getCurrent().getName() + " environment");
    }

    public boolean containsItem(int position) {
        try {
            this.items[position].toString();
            return true;
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
    }

    public ItemStackAdapter getItem(int position) {
        return this.containsItem(position) ? this.items[position] : null;
    }

    public void setItem(ItemStackAdapter itemStack, int position) {
        if (position < 0 || position > this.getSize() - 1) {
            return;
        }
        if (Environment.isBukkit()) {
            ((org.bukkit.inventory.Inventory)this.inventory).setItem(position, itemStack.bukkitValue());
        } else if (Environment.isSponge()) {
            this.spongeValue().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_PROPERTY.of((Object)SlotIndex.of((Object)position))}).set(itemStack.spongeValue());
        } else {
            this.fabricValue().method_5447(position, itemStack.fabricValue());
        }
        this.items[position] = itemStack;
    }

    public void clear() {
        if (Environment.isBukkit()) {
            this.bukkitValue().clear();
        } else if (Environment.isSponge()) {
            this.spongeValue().clear();
        } else {
            this.fabricValue().method_5448();
        }
        this.items = new ItemStackAdapter[this.size];
    }

    public int getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ChatPluginServerPlayer> getViewers() {
        if (Environment.isFabric()) {
            class_1277 fabricValue = this.fabricValue();
            return ServerPlayerManager.getInstance().getPlayers().values().stream().filter(player -> {
                class_1703 inventory = player.toAdapter().fabricValue().field_7512;
                return inventory instanceof class_1707 && ((class_1707)inventory).method_7629().equals((Object)fabricValue);
            }).collect(Collectors.toList());
        }
        return (Environment.isBukkit() ? this.bukkitValue().getViewers().stream().map(AnimalTamer::getUniqueId) : ((Container)this.inventory).getViewers().stream().map(Identifiable::getUniqueId)).map(ServerPlayerManager.getInstance()::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class SpongeInventory {
        private SpongeInventory() {
        }

        public static Inventory get(int rows, String title) {
            return Inventory.builder().property((InventoryProperty)InventoryTitle.of((Text)Utils.toSpongeComponent(title))).property((InventoryProperty)InventoryDimension.of((int)9, (int)rows)).build((Object)SpongeBootstrapper.getInstance());
        }
    }
}

