/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.entity;

import java.util.StringJoiner;
import java.util.UUID;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_1309;
import org.bukkit.entity.LivingEntity;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.text.Text;

public class LivingEntityAdapter {
    private Object livingEntity;

    public LivingEntityAdapter(Object livingEntity) {
        this.livingEntity = livingEntity;
    }

    public LivingEntity bukkitValue() {
        if (Environment.isBukkit()) {
            return (LivingEntity)this.livingEntity;
        }
        throw new UnsupportedOperationException("Unable to adapt living entity to a Bukkit's LivingEntity on a " + Environment.getCurrent().getName() + " environment");
    }

    public Living spongeValue() {
        if (Environment.isSponge()) {
            return (Living)this.livingEntity;
        }
        throw new UnsupportedOperationException("Unable to adapt living entity to a Sponge's Living on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1309 fabricValue() {
        if (Environment.isFabric()) {
            return (class_1309)this.livingEntity;
        }
        throw new UnsupportedOperationException("Unable to adapt living entity to a Sponge's LivingEntity on a " + Environment.getCurrent().getName() + " environment");
    }

    public String toString() {
        return new StringJoiner(", ", "LivingEntityAdapter{", "}").add("uuid=" + this.getUUID().toString()).add("name=\"" + this.getName() + "\"").add("health=" + this.getHealth()).add("maxHealth=" + this.getMaxHealth()).toString();
    }

    public UUID getUUID() {
        return Environment.isBukkit() ? this.bukkitValue().getUniqueId() : (Environment.isSponge() ? this.spongeValue().getUniqueId() : this.fabricValue().method_5667());
    }

    public String getName() {
        return Environment.isBukkit() ? this.bukkitValue().getName() : (Environment.isSponge() ? Utils.toLegacyText((Text)this.spongeValue().getOrElse(Keys.DISPLAY_NAME, (Object)Utils.toSpongeComponent(this.spongeValue().getType().getName()))) : Utils.toLegacyText(this.fabricValue().method_5476()));
    }

    public double getHealth() {
        return Environment.isBukkit() ? this.bukkitValue().getHealth() : (Environment.isSponge() ? (Double)this.spongeValue().health().get() : (double)this.fabricValue().method_6032());
    }

    public double getMaxHealth() {
        return Environment.isBukkit() ? this.bukkitValue().getMaxHealth() : (Environment.isSponge() ? (Double)this.spongeValue().maxHealth().get() : (double)this.fabricValue().method_6063());
    }
}

