/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.bossbar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.util.PseudoEnum;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_1259;
import org.bukkit.boss.BarColor;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;

public class BossbarColorAdapter
extends PseudoEnum<BossbarColorAdapter> {
    public static final BossbarColorAdapter BLUE = new BossbarColorAdapter("BLUE");
    public static final BossbarColorAdapter GREEN = new BossbarColorAdapter("GREEN");
    public static final BossbarColorAdapter PINK = new BossbarColorAdapter("PINK");
    public static final BossbarColorAdapter PURPLE = new BossbarColorAdapter("PURPLE");
    public static final BossbarColorAdapter RED = new BossbarColorAdapter("RED");
    public static final BossbarColorAdapter WHITE = new BossbarColorAdapter("WHITE");
    public static final BossbarColorAdapter YELLOW = new BossbarColorAdapter("YELLOW");
    public static final BossbarColorAdapter RANDOM = new BossbarColorAdapter("RANDOM");
    private static final BossbarColorAdapter[] VALUES = new BossbarColorAdapter[]{BLUE, GREEN, PINK, PURPLE, RED, WHITE, YELLOW, RANDOM};
    private static int ordinal = 0;
    private static Map<String, Object> spongeColors;

    private BossbarColorAdapter(String name) {
        super(name, ordinal++);
    }

    public BarColor bukkitValue() {
        if (Environment.isBukkit()) {
            return this == RANDOM ? BarColor.values()[VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9) ? ThreadLocalRandom.current().nextInt(BarColor.values().length) : 2] : BarColor.valueOf((String)this.name());
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar color to a Bukkit's BarColor on a " + Environment.getCurrent().getName() + " environment");
    }

    public BossBarColor spongeValue() {
        if (Environment.isSponge()) {
            return (BossBarColor)(this == RANDOM ? new ArrayList<Object>(spongeColors.values()).get(VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9) ? ThreadLocalRandom.current().nextInt(VALUES.length - 1) : 2) : spongeColors.get(this.name()));
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar color to a Sponge's BossBarColor on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1259.class_1260 fabricValue() {
        if (Environment.isFabric()) {
            return this == RANDOM ? class_1259.class_1260.values()[ThreadLocalRandom.current().nextInt(class_1259.class_1260.values().length)] : class_1259.class_1260.valueOf((String)this.name());
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar color to a Fabric's BossBar.Color on a " + Environment.getCurrent().getName() + " environment");
    }

    public boolean isSupported() {
        return Environment.isFabric() || this == PINK || this == RANDOM || VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9);
    }

    public static BossbarColorAdapter valueOf(String name) {
        return (BossbarColorAdapter)BossbarColorAdapter.valueOf((String)name, (PseudoEnum[])VALUES);
    }

    public static BossbarColorAdapter[] values() {
        return VALUES;
    }

    public static BossbarColorAdapter value(String name) {
        try {
            return BossbarColorAdapter.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static {
        if (Environment.isSponge()) {
            spongeColors = Stream.of({"BLUE", BossBarColors.BLUE}, {"GREEN", BossBarColors.GREEN}, {"PINK", BossBarColors.PINK}, {"PURPLE", BossBarColors.PURPLE}, {"RED", BossBarColors.RED}, {"WHITE", BossBarColors.WHITE}, {"YELLOW", BossBarColors.YELLOW}).collect(Collectors.toMap(color -> (String)color[0], color -> color[1], (x, y) -> y, LinkedHashMap::new));
        }
    }
}

