/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.bossbar;

import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.api.server.util.adapter.bossbar.BossbarColorAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.bossbar.BossbarStyleAdapter;
import me.remigio07.chatplugin.bootstrap.BukkitBootstrapper;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.plugin.Plugin;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.text.Text;

public class BossbarAdapter {
    private Object bossbar;
    private String id;

    public BossbarAdapter(Object bossbar) {
        this.bossbar = bossbar;
    }

    public BossbarAdapter(String id) {
        this.id = id;
        this.bossbar = Environment.isBukkit() ? BukkitBossbar.get(id) : (Environment.isSponge() ? SpongeBossbar.get() : FabricBootstrapper.getInstance().getServer().method_3837().method_12970(class_2960.method_12829((String)("chatplugin:" + id.toLowerCase())), Utils.toFabricComponent("")));
    }

    public String toString() {
        return "BossbarAdapter{id=" + (this.id == null ? this.id : "\"" + this.id + "\"") + "}";
    }

    public BossBar bukkitValue() {
        if (Environment.isBukkit()) {
            return (BossBar)this.bossbar;
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar to a Bukkit's ServerBossBar on a " + Environment.getCurrent().getName() + " environment");
    }

    public ServerBossBar spongeValue() {
        if (Environment.isSponge()) {
            return (ServerBossBar)this.bossbar;
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar to a Sponge's ServerBossBar on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_3002 fabricValue() {
        if (Environment.isFabric()) {
            return (class_3002)this.bossbar;
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar to a Fabric's CommandBossBar on a " + Environment.getCurrent().getName() + " environment");
    }

    public String getID() {
        return this.id;
    }

    public String getTitle() {
        return Environment.isBukkit() ? this.bukkitValue().getTitle() : (Environment.isSponge() ? Utils.toLegacyText(this.spongeValue().getName()) : Utils.toLegacyText(this.fabricValue().method_5414()));
    }

    public void setTitle(String title) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setTitle(title);
        } else if (Environment.isSponge()) {
            this.spongeValue().setName(Utils.toSpongeComponent(title));
        } else {
            this.fabricValue().method_5413(Utils.toFabricComponent(title));
        }
    }

    public float getProgress() {
        return Environment.isBukkit() ? (float)this.bukkitValue().getProgress() : (Environment.isSponge() ? this.spongeValue().getPercent() : this.fabricValue().method_5412());
    }

    public void setProgress(float progress) {
        float f = progress < 0.0f ? 0.0f : (progress = progress > 1.0f ? 1.0f : progress);
        if (Environment.isBukkit()) {
            this.bukkitValue().setProgress((double)progress);
        } else if (Environment.isSponge()) {
            this.spongeValue().setPercent(progress);
        } else {
            this.fabricValue().method_5408(progress);
        }
    }

    public boolean isVisible() {
        return Environment.isBukkit() ? this.bukkitValue().isVisible() : (Environment.isSponge() ? this.spongeValue().isVisible() : this.fabricValue().method_14093());
    }

    public void setVisible(boolean visible) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setVisible(visible);
        } else if (Environment.isSponge()) {
            this.spongeValue().setVisible(visible);
        } else {
            this.fabricValue().method_14091(visible);
        }
    }

    public BossbarColorAdapter getColor() {
        return BossbarColorAdapter.value(Environment.isBukkit() ? this.bukkitValue().getColor().name() : (Environment.isSponge() ? this.spongeValue().getColor().getId() : this.fabricValue().method_5420().name()));
    }

    public void setColor(BossbarColorAdapter color) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setColor(color.bukkitValue());
        } else if (Environment.isSponge()) {
            this.spongeValue().setColor(color.spongeValue());
        } else {
            this.fabricValue().method_5416(color.fabricValue());
        }
    }

    public BossbarStyleAdapter getStyle() {
        return BossbarStyleAdapter.value(Environment.isBukkit() ? this.bukkitValue().getStyle().name() : (Environment.isSponge() ? this.spongeValue().getOverlay().getId() : this.fabricValue().method_5415().name()));
    }

    public void setStyle(BossbarStyleAdapter style) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setStyle(style.bukkitValue());
        } else if (Environment.isSponge()) {
            this.spongeValue().setOverlay(style.spongeValue());
        } else {
            this.fabricValue().method_5409(style.fabricValue());
        }
    }

    public void addPlayer(ChatPluginServerPlayer player) {
        if (Environment.isBukkit()) {
            this.bukkitValue().addPlayer(player.toAdapter().bukkitValue());
        } else if (Environment.isSponge()) {
            this.spongeValue().addPlayer(player.toAdapter().spongeValue());
        } else {
            this.fabricValue().method_14088(player.toAdapter().fabricValue());
        }
    }

    public void removePlayer(ChatPluginServerPlayer player) {
        if (Environment.isBukkit()) {
            this.bukkitValue().removePlayer(player.toAdapter().bukkitValue());
        } else if (Environment.isSponge()) {
            this.spongeValue().removePlayer(player.toAdapter().spongeValue());
        } else {
            this.fabricValue().method_14089(player.toAdapter().fabricValue());
        }
    }

    public void remove() {
        if (Environment.isBukkit()) {
            this.bukkitValue().getPlayers().forEach(player -> this.bukkitValue().removePlayer(player));
            if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_13_2)) {
                BukkitBossbar.remove(this.id);
            }
        } else if (Environment.isFabric()) {
            this.fabricValue().method_14092().forEach(player -> this.fabricValue().method_14089(player));
            FabricBootstrapper.getInstance().getServer().method_3837().method_12973(this.fabricValue());
        } else {
            this.spongeValue().getPlayers().forEach(player -> this.spongeValue().removePlayer(player));
        }
    }

    private static class BukkitBossbar {
        private BukkitBossbar() {
        }

        public static BossBar get(String id) {
            return VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_13_2) ? Bukkit.createBossBar((NamespacedKey)new NamespacedKey((Plugin)BukkitBootstrapper.getInstance(), id), (String)"", (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]) : Bukkit.createBossBar((String)"", (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        }

        public static void remove(String id) {
            NamespacedKey key = new NamespacedKey((Plugin)BukkitBootstrapper.getInstance(), id);
            if (Bukkit.getBossBar((NamespacedKey)key) != null) {
                Bukkit.removeBossBar((NamespacedKey)key);
            }
        }
    }

    private static class SpongeBossbar {
        private SpongeBossbar() {
        }

        public static ServerBossBar get() {
            return ServerBossBar.builder().name(Text.EMPTY).color(BossBarColors.PINK).overlay(BossBarOverlays.PROGRESS).build();
        }
    }
}

