/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.block;

import java.lang.reflect.Method;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.bukkit.Material;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;

public class MaterialAdapter
implements Cloneable {
    public static final MaterialAdapter AIR = new MaterialAdapter();
    private Object material;
    private String id;

    private MaterialAdapter() {
        this.material = Environment.isBukkit() ? Material.AIR : (Environment.isSponge() ? (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_11) ? ItemTypes.AIR : ItemTypes.NONE) : (Environment.isFabric() ? class_1802.field_8162 : null));
        this.id = "minecraft:air";
    }

    public MaterialAdapter(String id) {
        switch (id) {
            case "AIR": 
            case "air": 
            case "minecraft:air": {
                break;
            }
            case "NONE": {
                if (Environment.isSponge() && !VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_11)) break;
                throw new IllegalArgumentException("Unknown material ID: " + id);
            }
            default: {
                try {
                    if (Environment.isBukkit()) {
                        if (id.equals(id.toUpperCase())) {
                            this.material = Material.valueOf((String)id);
                        }
                        if (this.material == null) {
                            if (id.startsWith("minecraft:")) {
                                id = id.substring(10);
                            }
                            if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_13)) {
                                Class<?> Item = Class.forName("net.minecraft.server." + VersionUtils.getNMSVersion() + ".Item");
                                this.material = Material.class.getMethod("getMaterial", Integer.TYPE).invoke(null, Item.getMethod("getId", Item).invoke(null, Item.getMethod(VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_11) ? "b" : "d", String.class).invoke(null, id)));
                                if (this.material == Material.AIR) {
                                    throw new IllegalArgumentException();
                                }
                            } else {
                                this.material = Material.valueOf((String)id.toUpperCase());
                            }
                        }
                    } else if (Environment.isSponge()) {
                        if (id.equals(id.toUpperCase())) {
                            this.material = ItemTypes.class.getField(id).get(null);
                        }
                        if (this.material == null) {
                            this.material = Sponge.getRegistry().getType(ItemType.class, id).orElse(null);
                        }
                    } else if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_19_3)) {
                        if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_2)) {
                            if (id.equals(id.toUpperCase())) {
                                this.material = class_7923.field_41178.method_63535(class_2960.method_60656((String)id.toLowerCase()));
                            }
                            if (this.material == null) {
                                this.material = class_7923.field_41178.method_63535(id.contains(":") ? class_2960.method_60654((String)id) : class_2960.method_60656((String)id));
                            }
                        } else {
                            Method get = class_2378.class.getMethod("method_10223", class_2960.class);
                            if (id.equals(id.toUpperCase())) {
                                this.material = get.invoke((Object)class_7923.field_41178, class_2960.method_43902((String)"minecraft", (String)id.toLowerCase()));
                            }
                            if (this.material == null) {
                                this.material = get.invoke((Object)class_7923.field_41178, id.contains(":") ? class_2960.method_12829((String)id) : class_2960.method_43902((String)"minecraft", (String)id));
                            }
                        }
                    } else {
                        Method get = class_2378.class.getMethod("method_10223", class_2960.class);
                        Object ITEM = class_2378.class.getField("field_11142").get(null);
                        if (id.equals(id.toUpperCase())) {
                            this.material = get.invoke(ITEM, class_2960.method_12829((String)("minecraft:" + id.toLowerCase())));
                        }
                        if (this.material == null) {
                            this.material = get.invoke(ITEM, id.contains(":") ? class_2960.method_12829((String)id) : class_2960.method_12829((String)("minecraft:" + id)));
                        }
                    }
                    this.material.toString();
                    this.id = id;
                    return;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown material ID: " + id);
                }
            }
        }
        this.material = MaterialAdapter.AIR.material;
        this.id = id;
    }

    public MaterialAdapter clone() {
        return new MaterialAdapter(this.id);
    }

    public String toString() {
        return "MaterialAdapter{id=\"" + this.id + "\"}";
    }

    public Material bukkitValue() {
        if (Environment.isBukkit()) {
            return (Material)this.material;
        }
        throw new UnsupportedOperationException("Unable to adapt material to a Bukkit's Material on a " + Environment.getCurrent().getName() + " environment");
    }

    public ItemType spongeValue() {
        if (Environment.isSponge()) {
            return (ItemType)this.material;
        }
        throw new UnsupportedOperationException("Unable to adapt material to a Sponge's ItemType on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1792 fabricValue() {
        if (Environment.isFabric()) {
            return (class_1792)this.material;
        }
        throw new UnsupportedOperationException("Unable to adapt material to a Fabric's Item on a " + Environment.getCurrent().getName() + " environment");
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof MaterialAdapter && ((MaterialAdapter)obj).material.equals(this.material);
    }

    public int hashCode() {
        return this.material.hashCode();
    }
}

