/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.block;

import java.lang.reflect.InvocationTargetException;
import java.util.StringJoiner;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.util.adapter.block.MaterialAdapter;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import org.bukkit.block.Block;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.world.Location;

public class BlockAdapter {
    private Object block;
    private MaterialAdapter type;

    public BlockAdapter(Object block) {
        this.block = block;
        String id = null;
        if (Environment.isBukkit()) {
            id = this.bukkitValue().getType().name();
        } else if (Environment.isSponge()) {
            id = ((ItemType)this.spongeValue().getState().getType().getItem().get()).getId().substring(10);
        } else if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_19_3)) {
            try {
                id = class_2378.class.getMethod("method_10221", Object.class).invoke(class_2378.class.getField("field_11142").get(null), this.fabricValue().getBlock().method_8389()).toString();
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            id = class_7923.field_41178.method_10221((Object)this.fabricValue().getBlock().method_8389()).toString();
        }
        this.type = new MaterialAdapter(id);
    }

    public String toString() {
        return new StringJoiner(", ", "BlockAdapter{", "}").add("type=" + this.getType()).add("x=" + this.getX()).add("y=" + this.getY()).add("z=" + this.getZ()).toString();
    }

    public Block bukkitValue() {
        if (Environment.isBukkit()) {
            return (Block)this.block;
        }
        throw new UnsupportedOperationException("Unable to adapt block to a Bukkit's Block on a " + Environment.getCurrent().getName() + " environment");
    }

    public BlockSnapshot spongeValue() {
        if (Environment.isSponge()) {
            return (BlockSnapshot)this.block;
        }
        throw new UnsupportedOperationException("Unable to adapt block to a Sponge's BlockSnapshot on a " + Environment.getCurrent().getName() + " environment");
    }

    public FabricBlock fabricValue() {
        if (Environment.isFabric()) {
            return (FabricBlock)this.block;
        }
        throw new UnsupportedOperationException("Unable to adapt block to a Fabric's FabricBlock on a " + Environment.getCurrent().getName() + " environment");
    }

    public MaterialAdapter getType() {
        return this.type;
    }

    public int getX() {
        return Environment.isBukkit() ? this.bukkitValue().getX() : (Environment.isSponge() ? ((Location)this.spongeValue().getLocation().get()).getBlockX() : this.fabricValue().getBlockPos().method_10263());
    }

    public int getY() {
        return Environment.isBukkit() ? this.bukkitValue().getY() : (Environment.isSponge() ? ((Location)this.spongeValue().getLocation().get()).getBlockY() : this.fabricValue().getBlockPos().method_10264());
    }

    public int getZ() {
        return Environment.isBukkit() ? this.bukkitValue().getZ() : (Environment.isSponge() ? ((Location)this.spongeValue().getLocation().get()).getBlockZ() : this.fabricValue().getBlockPos().method_10260());
    }

    public static class FabricBlock {
        private class_2248 block;
        private class_2338 blockPos;

        public FabricBlock(class_2248 block, class_2338 blockPos) {
            this.block = block;
            this.blockPos = blockPos;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public class_2338 getBlockPos() {
            return this.blockPos;
        }
    }
}

