/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.server.chat.ChatManager;

public class URLValidator {
    public static final Pattern DOMAIN_NAME_PATTERN = Pattern.compile("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}$");
    private static List<String> protocols = Arrays.asList("http://", "https://");

    public static List<String> getURLs(String input) {
        if (!input.contains(".")) {
            return Collections.emptyList();
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (String word : input.split(" ")) {
            if (!word.contains(".") || URLValidator.getDomainName(word) == null) continue;
            urls.add(word);
        }
        return urls;
    }

    public static String stripProtocol(String url) {
        for (String protocol : protocols) {
            if (!url.toLowerCase().startsWith(protocol)) continue;
            url = url.substring(url.indexOf(58) + 3);
        }
        return url;
    }

    public static String getDomainName(String url) {
        if (!ChatManager.getInstance().isEnabled()) {
            return null;
        }
        if ((url = URLValidator.stripProtocol(url.toLowerCase())).contains("/")) {
            url = url.substring(0, url.indexOf(47));
        }
        return DOMAIN_NAME_PATTERN.matcher(url).find() ? (ChatManager.getInstance().getRecognizedTLDs().contains(url.substring(url.lastIndexOf(46) + 1).toLowerCase()) ? url : null) : null;
    }
}

