/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public enum PlaceholderType {
    JUST_NAME(new String[]{"player"}),
    PLAYER(new String[]{"player", "uuid", "display_name", "ip_address", "health", "max_health", "food", "level", "xp", "gamemode", "language_id", "language_display_name", "locale", "version", "version_protocol", "client_edition", "last_login", "time_played", "emojis_tone", "world", "online_world", "vanished_world", "ping", "ping_format", "ping_quality_color", "ping_quality_text", "player_id", "player_bans", "player_warnings", "player_kicks", "player_mutes", "messages_sent", "player_anticheat_bans", "player_anticheat_warnings", "player_anticheat_kicks", "player_anticheat_mutes", "x", "y", "z", "yaw", "pitch", "rank_id", "rank_display_name", "prefix", "suffix", "tag_prefix", "tag_suffix", "tag_name_color", "chat_color", "rank_description", "isp", "continent", "country", "subdivisions", "city", "country_code", "inside_eu", "time_zone", "postal_code", "latitude", "longitude", "accuracy_radius_km", "accuracy_radius_mi", "accuracy_radius_nm", "relative_date_full", "relative_date_day", "relative_date_hour"}),
    SERVER(new String[]{"online", "online@server-id", "online_total", "max_players", "vanished", "vanished@server-id", "date_full", "date_day", "date_hour", "enabled_worlds", "enabled_players", "enabled_managers", "startup_time", "last_reload_time", "uptime", "random_color", "plugin_version", "server_version", "server_version_protocol", "server_nms_version", "server_java_version", "server_id", "server_display_name", "main_language_id", "main_language_display_name", "total_players", "total_bans", "total_warnings", "total_kicks", "total_mutes", "total_staff_bans", "total_staff_warnings", "total_staff_kicks", "total_staff_mutes", "total_anticheat_bans", "total_anticheat_warnings", "total_anticheat_kicks", "total_anticheat_mutes", "max_memory", "total_memory", "used_memory", "free_memory", "total_storage", "used_storage", "free_storage", "unallocated_storage", "tps_1_min", "tps_5_min", "tps_15_min", "tps_1_min_format", "tps_5_min_format", "tps_15_min_format", "mspt_5_sec_avg", "mspt_5_sec_min", "mspt_5_sec_max", "mspt_10_sec_avg", "mspt_10_sec_min", "mspt_10_sec_max", "mspt_1_min_avg", "mspt_1_min_min", "mspt_1_min_max", "mspt_5_sec_avg_format", "mspt_5_sec_min_format", "mspt_5_sec_max_format", "mspt_10_sec_avg_format", "mspt_10_sec_min_format", "mspt_10_sec_max_format", "mspt_1_min_avg_format", "mspt_1_min_min_format", "mspt_1_min_max_format", "server_os_name", "server_os_arch", "server_os_version", "cpu_threads", "active_threads", "discord_punishments_channel_id", "discord_staff_notifications_channel_id"}),
    INTEGRATIONS(new String[]{"version", "version_protocol", "balance"});

    private String[] placeholders;

    private PlaceholderType(String[] placeholders) {
        this.placeholders = placeholders;
    }

    public String[] getPlaceholders() {
        return this.placeholders;
    }

    public static PlaceholderType getType(String placeholder) {
        if (placeholder.startsWith("online@") || placeholder.startsWith("vanished@")) {
            return SERVER;
        }
        for (PlaceholderType type : PlaceholderType.values()) {
            for (String identifier : type.getPlaceholders()) {
                if (!placeholder.equals(identifier)) continue;
                return type;
            }
        }
        return null;
    }

    public static Set<PlaceholderType> getTypes(List<String> types) {
        EnumSet<PlaceholderType> set = EnumSet.noneOf(PlaceholderType.class);
        for (String type : types) {
            try {
                set.add(PlaceholderType.valueOf(type.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return set;
    }

    public static int count() {
        return PLAYER.getPlaceholders().length + SERVER.getPlaceholders().length + INTEGRATIONS.getPlaceholders().length;
    }
}

