/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.tablist;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.tablist.Tablist;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

public abstract class TablistManager
implements ChatPluginManager,
Runnable {
    public static final Pattern TABLIST_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static TablistManager instance;
    protected boolean enabled;
    protected boolean randomOrder;
    protected boolean playerNamesTeamsMode;
    protected long sendingTimeout;
    protected long playerNamesUpdateTimeout;
    protected long timerTaskID = -1L;
    protected long playerNamesTimerTaskID = -1L;
    protected String playerNamesPrefix;
    protected String playerNamesSuffix;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<Tablist> tablists = new CopyOnWriteArrayList<Tablist>();
    protected Runnable playerNamesUpdater;
    protected int timerIndex = -1;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public boolean isPlayerNamesTeamsMode() {
        return this.playerNamesTeamsMode;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    public long getPlayerNamesUpdateTimeout() {
        return this.playerNamesUpdateTimeout;
    }

    public String getPlayerNamesPrefix() {
        return this.playerNamesPrefix;
    }

    public String getPlayerNamesSuffix() {
        return this.playerNamesSuffix;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<Tablist> getTablists() {
        return this.tablists;
    }

    public Tablist getTablist(String id) {
        return this.tablists.stream().filter(tablist -> tablist.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public Runnable getPlayerNamesUpdater() {
        return this.playerNamesUpdater;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public long getPlayerNamesTimerTaskID() {
        return this.playerNamesTimerTaskID;
    }

    public int getTimerIndex() {
        return this.timerIndex;
    }

    public boolean isValidTablistID(String tablistID) {
        return TABLIST_ID_PATTERN.matcher(tablistID).matches();
    }

    public static TablistManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract void sendTablist(Tablist var1, ChatPluginServerPlayer var2);
}

