/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.tablist;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.tablist.TablistManager;

public class Tablist {
    public static final Tablist NULL_TABLIST = new Tablist();
    private String id;
    private Map<Language, String> headers;
    private Map<Language, String> footers;

    private Tablist() {
        this.footers = Collections.emptyMap();
        this.headers = this.footers;
    }

    public Tablist(String id, Map<Language, String> headers, Map<Language, String> footers) {
        if (!TablistManager.getInstance().isValidTablistID(id)) {
            throw new IllegalArgumentException("Tablist ID \"" + id + "\" does not respect the following pattern: \"" + TablistManager.TABLIST_ID_PATTERN.pattern() + "\"");
        }
        if (headers.get(Language.getMainLanguage()) == null || footers.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified map does not contain a translation for the main language");
        }
        this.id = id;
        this.headers = headers;
        this.footers = footers;
    }

    public String toString() {
        return "Tablist{id=\"" + this.id + "\"}";
    }

    public String getID() {
        return this.id;
    }

    public Map<Language, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(Language language, boolean avoidNull) {
        return this.headers.get(language) == null ? (avoidNull ? this.headers.get(Language.getMainLanguage()) : null) : this.headers.get(language);
    }

    public Map<Language, String> getFooters() {
        return this.footers;
    }

    public String getFooter(Language language, boolean avoidNull) {
        return this.footers.get(language) == null ? (avoidNull ? this.footers.get(Language.getMainLanguage()) : null) : this.footers.get(language);
    }
}

