/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.scoreboard;

import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.scoreboard.Scoreboard;

public abstract class ScoreboardTitles
extends TimerTask {
    public static final int MAX_TITLE_LENGTH = VersionUtils.getVersion().getProtocol() > 340 ? 128 : 32;
    public static final String TITLE_TOO_LONG = "\u00a7cTitle exceeds \u00a7f" + MAX_TITLE_LENGTH + " \u00a7cchars";
    protected Scoreboard scoreboard;
    protected Map<Language, List<String>> values = new ConcurrentHashMap<Language, List<String>>();
    protected Map<Language, Integer> timerIndexes = new ConcurrentHashMap<Language, Integer>();
    protected boolean randomOrder;
    protected long sendingTimeout;

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Map<Language, List<String>> getValues() {
        return this.values;
    }

    public List<String> getValues(Language language, boolean avoidNull) {
        return this.values.get(language) == null ? (avoidNull ? this.values.get(Language.getMainLanguage()) : null) : this.values.get(language);
    }

    public Map<Language, Integer> getTimerIndexes() {
        return this.timerIndexes;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    @Override
    public abstract void run();
}

