/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.scoreboard;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.scoreboard.NumbersDisplayMode;
import me.remigio07.chatplugin.api.server.scoreboard.ScoreboardLines;
import me.remigio07.chatplugin.api.server.scoreboard.ScoreboardNumbers;
import me.remigio07.chatplugin.api.server.scoreboard.ScoreboardTitles;
import me.remigio07.chatplugin.api.server.scoreboard.ScoreboardType;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;
import me.remigio07.chatplugin.bootstrap.Environment;

public abstract class Scoreboard {
    public static final String[] SCORES = new String[15];
    protected String id;
    protected ScoreboardType type;
    protected Configuration configuration;
    protected ScoreboardTitles titles;
    protected ScoreboardLines lines;
    protected ScoreboardNumbers numbers;
    protected boolean abbreviateLongText;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<ChatPluginServerPlayer> players = new CopyOnWriteArrayList<ChatPluginServerPlayer>();

    public String getID() {
        return this.id;
    }

    public ScoreboardType getType() {
        return this.type;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ScoreboardTitles getTitles() {
        return this.titles;
    }

    public ScoreboardLines getLines() {
        return this.lines;
    }

    public ScoreboardNumbers getNumbers() {
        return this.numbers;
    }

    public boolean shouldAbbreviateLongText() {
        return this.abbreviateLongText;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<ChatPluginServerPlayer> getPlayers() {
        return this.players;
    }

    public abstract void addPlayer(ChatPluginServerPlayer var1);

    public abstract void removePlayer(ChatPluginServerPlayer var1);

    static {
        if (Environment.isSponge()) {
            for (int i = 0; i < 15; ++i) {
                Scoreboard.SCORES[i] = (i == 0 ? "" : SCORES[i - 1]) + "\u00a7\u00a7";
            }
        } else {
            for (int i = 0; i < 15; ++i) {
                Scoreboard.SCORES[i] = ChatColor.values()[i].toString() + "\u00a7r";
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder setTitles(Map<Language, List<String>> var1, boolean var2, long var3);

        public abstract Builder setLine(Map<Language, List<String>> var1, int var2, boolean var3, long var4);

        public abstract Builder setNumbers(NumbersDisplayMode var1, String var2, long var3, int var5, List<ChatColor> var6);

        public abstract Scoreboard build();
    }
}

