/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.rank;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.rank.RankManager;
import me.remigio07.chatplugin.api.server.rank.RankTag;

public abstract class Rank {
    public static final String[] PLACEHOLDERS = new String[]{"rank_id", "rank_display_name", "prefix", "suffix", "tag_prefix", "tag_suffix", "tag_name_color", "chat_color", "rank_position", "rank_description", "max_ban_duration", "max_mute_duration"};
    protected String id;
    protected String displayName;
    protected String prefix;
    protected String suffix;
    protected String chatColor;
    protected RankTag tag;
    protected int position;
    protected Map<Language, String> descriptions = new HashMap<Language, String>();
    protected long[] maxPunishmentDurations = new long[2];

    protected Rank(String id, int position) {
        this.id = id;
        this.position = position;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public RankTag getTag() {
        return this.tag;
    }

    public String getChatColor() {
        return this.chatColor;
    }

    public int getPosition() {
        return this.position;
    }

    public Map<Language, String> getDescriptions() {
        return this.descriptions;
    }

    public String getDescription(Language language, boolean avoidNull) {
        return this.descriptions.get(language) == null ? (avoidNull ? this.descriptions.get(Language.getMainLanguage()) : null) : this.descriptions.get(language);
    }

    public long[] getMaxPunishmentDurations() {
        return this.maxPunishmentDurations;
    }

    public String formatPosition() {
        if (!RankManager.getInstance().isSortingEnabled()) {
            return "00";
        }
        String str = RankManager.getInstance().isSortingFromTablistTop() ? String.valueOf(RankManager.getInstance().getRanks().size() - this.position - 1) : String.valueOf(this.position);
        return str.length() == 1 ? "0" + str : str;
    }

    public String formatIdentifier(ChatPluginServerPlayer player) {
        return this.formatPosition() + String.format("%-4s", player.getName()).substring(0, 4) + String.format("%010d", player.getID());
    }

    public abstract String formatPlaceholders(String var1, Language var2);

    public abstract List<String> formatPlaceholders(List<String> var1, Language var2);
}

