/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.player;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookupManager;
import me.remigio07.chatplugin.api.common.player.ChatPluginPlayer;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.bossbar.PlayerBossbar;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannel;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannelsManager;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;
import me.remigio07.chatplugin.api.server.event.chat.channel.ChatChannelJoinEvent;
import me.remigio07.chatplugin.api.server.event.chat.channel.ChatChannelLeaveEvent;
import me.remigio07.chatplugin.api.server.event.chat.channel.ChatChannelSwitchEvent;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.rank.Rank;
import me.remigio07.chatplugin.api.server.scoreboard.Scoreboard;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.InventoryAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.scoreboard.ObjectiveAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;
import me.remigio07.chatplugin.api.server.util.manager.VanishManager;

public abstract class ChatPluginServerPlayer
extends OfflinePlayer
implements ChatPluginPlayer {
    protected VersionUtils.Version version;
    protected boolean bedrockPlayer;
    protected boolean socialspyEnabled;
    protected boolean chatChannelSpyEnabled;
    protected boolean actionbarEnabled = true;
    protected Rank rank;
    protected Language language;
    protected Scoreboard scoreboard;
    protected PlayerBossbar bossbar;
    protected IPLookup ipLookup;
    protected ObjectiveAdapter objective;
    protected Object playerConnection;
    protected int ping;
    protected int id;
    protected int messagesSent;
    protected int antispamInfractions;
    protected short bans;
    protected short anticheatBans;
    protected short warnings;
    protected short anticheatWarnings;
    protected short kicks;
    protected short anticheatKicks;
    protected short mutes;
    protected short anticheatMutes;
    protected long loginTime;
    protected OfflinePlayer lastCorrespondent;
    protected ChatColor chatColor;
    protected ChatColor emojisTone;
    protected ChatChannel<? extends ChatChannelData> writingChannel;
    protected List<OfflinePlayer> ignoredPlayers;

    protected ChatPluginServerPlayer(PlayerAdapter player) {
        super(player);
    }

    @Override
    public VersionUtils.Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isBedrockPlayer() {
        return this.bedrockPlayer;
    }

    public boolean hasSocialspyEnabled() {
        return this.socialspyEnabled;
    }

    public void setSocialspyEnabled(boolean socialspyEnabled) {
        this.socialspyEnabled = socialspyEnabled;
    }

    public boolean hasChatChannelSpyEnabled() {
        return this.chatChannelSpyEnabled;
    }

    public void setChatChannelSpyEnabled(boolean chatChannelSpyEnabled) {
        this.chatChannelSpyEnabled = chatChannelSpyEnabled;
    }

    public boolean hasActionbarEnabled() {
        return this.actionbarEnabled;
    }

    public void setActionbarEnabled(boolean actionbarEnabled) {
        this.actionbarEnabled = actionbarEnabled;
    }

    public Rank getRank() {
        return this.rank;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public PlayerBossbar getBossbar() {
        return this.bossbar;
    }

    public CompletableFuture<IPLookup> getIPLookup(boolean generateIfNull) {
        if (this.ipLookup == null) {
            if (IPLookupManager.getInstance().isEnabled() && generateIfNull) {
                CompletableFuture<IPLookup> future = new CompletableFuture<IPLookup>();
                TaskManager.runAsync(() -> {
                    try {
                        this.ipLookup = IPLookupManager.getInstance().getIPLookup(this.getIPAddress()).get(5L, TimeUnit.SECONDS);
                        future.complete(this.ipLookup);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LogManager.log("{0} occurred while waiting for the IP ({1}) lookup of {2}: {3}", 2, e.getClass().getSimpleName(), this.getIPAddress().getHostAddress(), this.name, e.getLocalizedMessage());
                        future.complete(IPLookupManager.getInstance().getDisabledFeatureConstructor());
                    }
                }, 0L);
                return future;
            }
            return CompletableFuture.completedFuture(IPLookupManager.getInstance().getDisabledFeatureConstructor());
        }
        return CompletableFuture.completedFuture(this.ipLookup);
    }

    public ObjectiveAdapter getObjective() {
        return this.objective;
    }

    public Object getPlayerConnection() {
        return this.playerConnection;
    }

    public int getPing() {
        return this.ping;
    }

    public int getID() {
        return this.id;
    }

    public int getBans() {
        return this.bans;
    }

    public short getAnticheatBans() {
        return this.anticheatBans;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public short getAnticheatWarnings() {
        return this.anticheatWarnings;
    }

    public int getKicks() {
        return this.kicks;
    }

    public short getAnticheatKicks() {
        return this.anticheatKicks;
    }

    public int getMutes() {
        return this.mutes;
    }

    public short getAnticheatMutes() {
        return this.anticheatMutes;
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public int getAntispamInfractions() {
        return this.antispamInfractions;
    }

    public long getLoginTime() {
        return this.loginTime;
    }

    public boolean isVanished() {
        return VanishManager.getInstance().isEnabled() && VanishManager.getInstance().isVanished(this);
    }

    public OfflinePlayer getLastCorrespondent() {
        return this.lastCorrespondent;
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }

    public ChatColor getEmojisTone() {
        return this.emojisTone;
    }

    public ChatChannel<? extends ChatChannelData> getWritingChannel() {
        return this.writingChannel;
    }

    public List<ChatChannel<? extends ChatChannelData>> getChannels() {
        return ChatChannelsManager.getInstance().getChannels().stream().filter(channel -> channel.getListeners().contains(this)).collect(Collectors.toList());
    }

    public boolean joinChannel(ChatChannel<? extends ChatChannelData> channel) {
        if (!ChatChannelsManager.getInstance().isEnabled() || channel.getListeners().contains(this)) {
            return false;
        }
        ChatChannelJoinEvent event = new ChatChannelJoinEvent(this, channel);
        event.call();
        if (event.isCancelled()) {
            return false;
        }
        channel.getListeners().add(this);
        return true;
    }

    public boolean leaveChannel(ChatChannel<? extends ChatChannelData> channel) {
        if (this.getWritingChannel().equals(channel) && this.isLoaded()) {
            throw new IllegalArgumentException("Unable to make player leave their current writing channel");
        }
        if (!ChatChannelsManager.getInstance().isEnabled() || !channel.getListeners().contains(this)) {
            return false;
        }
        ChatChannelLeaveEvent event = new ChatChannelLeaveEvent(this, channel);
        event.call();
        if (event.isCancelled() && this.isLoaded()) {
            return false;
        }
        channel.getListeners().remove(this);
        return true;
    }

    public boolean switchChannel(ChatChannel<? extends ChatChannelData> channel) {
        if (!ChatChannelsManager.getInstance().isEnabled() || !this.getChannels().contains(channel) && !this.joinChannel(channel)) {
            return false;
        }
        ChatChannelSwitchEvent event = new ChatChannelSwitchEvent(this, channel);
        event.call();
        if (event.isCancelled()) {
            return false;
        }
        this.writingChannel = channel;
        return true;
    }

    public List<OfflinePlayer> getIgnoredPlayers() {
        return this.ignoredPlayers;
    }

    public void sendTranslatedMessage(String path, Object ... args) {
        this.sendMessage(this.language.getMessage(path, args));
    }

    public void sendTranslatedMessage(String path, String[] placeholders, Object ... args) {
        this.sendMessage(Utils.replaceCustomPlaceholders(this.language.getMessage(path, new Object[0]), placeholders, args));
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 500, 3500, 1000);
    }

    public abstract void sendTitle(String var1, String var2, int var3, int var4, int var5);

    public abstract void sendActionbar(String var1);

    @Deprecated
    public abstract void sendPacket(Object var1);

    public abstract void openInventory(InventoryAdapter var1);

    public abstract void closeInventory();

    public abstract void playSound(SoundAdapter var1);

    public abstract void executeCommand(String var1);

    public abstract void teleport(ChatPluginServerPlayer var1);

    public abstract String getDisplayName();

    public abstract String getWorld();

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getDistance(double var1, double var3, double var5);

    public abstract Locale getLocale();

    public abstract void setChatColor(ChatColor var1);

    public abstract void setEmojisTone(ChatColor var1);
}

