/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.language;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.language.LanguageDetector;

public abstract class LanguageManager
implements ChatPluginManager {
    public static final Pattern LANGUAGE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static LanguageManager instance;
    protected boolean enabled;
    protected LanguageDetector detector;
    protected List<Language> languages = new CopyOnWriteArrayList<Language>();
    protected Language mainLanguage;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public LanguageDetector getDetector() {
        return this.detector;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public Language getLanguage(String id) {
        return this.languages.stream().filter(language -> language.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public Language getMainLanguage() {
        return this.mainLanguage;
    }

    public boolean isValidLanguageID(String languageID) {
        return LANGUAGE_ID_PATTERN.matcher(languageID).matches();
    }

    public static LanguageManager getInstance() {
        return instance;
    }

    public abstract Language getLanguage(OfflinePlayer var1);

    public abstract void setLanguage(OfflinePlayer var1, Language var2);
}

