/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.language;

import java.util.concurrent.CompletableFuture;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.language.LanguageDetectionMethod;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public abstract class LanguageDetector {
    protected boolean enabled;
    protected LanguageDetectionMethod method;
    protected long delay;

    public void unload() {
        this.enabled = false;
        this.method = null;
        this.delay = 0L;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public LanguageDetectionMethod getMethod() {
        return this.method;
    }

    public long getDelay() {
        return this.delay;
    }

    public CompletableFuture<Language> detect(ChatPluginServerPlayer player) {
        if (this.enabled) {
            switch (this.method) {
                case CLIENT_LOCALE: {
                    return CompletableFuture.completedFuture(this.detectUsingClientLocale(player));
                }
                case GEOLOCALIZATION: {
                    CompletableFuture<Language> future = new CompletableFuture<Language>();
                    TaskManager.runAsync(() -> future.complete(this.detectUsingGeolocalization(player.getIPLookup(true).join())), 0L);
                    return future;
                }
            }
        }
        return CompletableFuture.completedFuture(Language.getMainLanguage());
    }

    public abstract void load();

    public abstract Language detectUsingClientLocale(ChatPluginServerPlayer var1);

    public abstract Language detectUsingGeolocalization(IPLookup var1);
}

