/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.gui.FillableGUI;
import me.remigio07.chatplugin.api.server.gui.FillableGUILayout;
import me.remigio07.chatplugin.api.server.gui.GUI;
import me.remigio07.chatplugin.api.server.gui.GUILayout;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.gui.OpenActions;
import me.remigio07.chatplugin.api.server.gui.SinglePageGUI;
import me.remigio07.chatplugin.api.server.gui.SinglePageGUILayout;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.GameFeature;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

@GameFeature(name="GUI", minimumSpongeVersion=VersionUtils.Version.V1_12)
public abstract class GUIManager
implements ChatPluginManager {
    public static final Pattern GUI_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    public static final Pattern PER_PLAYER_GUI_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,19}$");
    protected static GUIManager instance;
    protected boolean enabled;
    protected List<GUI> guis = new CopyOnWriteArrayList<GUI>();
    protected long perPlayerGUIsUnloadTime;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<GUI> getGUIs() {
        return this.guis;
    }

    public GUI getGUI(String id) {
        return this.guis.stream().filter(gui -> gui.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public void addGUI(GUI gui) {
        if (this.guis.stream().anyMatch(other -> other.getID().equalsIgnoreCase(gui.getID()))) {
            throw new IllegalArgumentException("Specified ID (" + gui.getID() + ") is already in use");
        }
        this.guis.add(gui);
    }

    public long getPerPlayerGUIsUnloadTime() {
        return this.perPlayerGUIsUnloadTime;
    }

    public SinglePageGUI createSinglePageGUI(SinglePageGUILayout layout) {
        return (SinglePageGUI)this.createGUI(layout);
    }

    public FillableGUI<?> createFillableGUI(FillableGUILayout layout) {
        return (FillableGUI)this.createGUI(layout);
    }

    public boolean isValidGUIID(String guiID) {
        return GUI_ID_PATTERN.matcher(guiID).matches();
    }

    public boolean isValidPerPlayerGUIID(String perPlayerGUIID) {
        return PER_PLAYER_GUI_ID_PATTERN.matcher(perPlayerGUIID).matches();
    }

    public static GUIManager getInstance() {
        return instance;
    }

    public abstract GUILayout createGUILayout(Configuration var1);

    public abstract SinglePageGUILayout.Builder createSinglePageGUILayoutBuilder(String var1, int var2, OpenActions var3, SoundAdapter var4, Map<Language, String> var5);

    public abstract FillableGUILayout.Builder createFillableGUILayoutBuilder(String var1, int var2, OpenActions var3, SoundAdapter var4, Map<Language, String> var5);

    public abstract GUI createGUI(GUILayout var1);

    public abstract <T extends GUI> T createPerPlayerGUI(GUILayout var1, ChatPluginServerPlayer var2);

    public abstract Icon createIcon(Configuration var1, String var2);

    public abstract GUI getOpenGUI(ChatPluginServerPlayer var1);
}

