/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import me.remigio07.chatplugin.api.common.util.TriFunction;
import me.remigio07.chatplugin.api.server.gui.FillableGUILayout;
import me.remigio07.chatplugin.api.server.gui.GUI;
import me.remigio07.chatplugin.api.server.gui.GUIFiller;
import me.remigio07.chatplugin.api.server.gui.GUILayout;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.ClickEventAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.DragEventAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.InventoryAdapter;
import me.remigio07.chatplugin.api.server.util.manager.PlaceholderManager;

public abstract class FillableGUI<T>
extends GUI {
    protected List<GUIFiller<T>> fillers = new CopyOnWriteArrayList<GUIFiller<T>>();
    protected List<List<Icon>> generatedIcons = new CopyOnWriteArrayList<List<Icon>>();
    protected Map<Language, List<InventoryAdapter>> inventories = new ConcurrentHashMap<Language, List<InventoryAdapter>>();
    protected Map<ChatPluginServerPlayer, Integer> viewers = new ConcurrentHashMap<ChatPluginServerPlayer, Integer>();
    protected TriFunction<String, Language, Integer, String> titlesTranslator;

    protected FillableGUI(GUILayout layout) {
        super(layout);
    }

    @Override
    public FillableGUILayout getLayout() {
        return (FillableGUILayout)this.layout;
    }

    public List<GUIFiller<T>> getFillers() {
        return this.fillers;
    }

    public GUIFiller<T> getFiller(T filler) {
        for (GUIFiller<T> guiFiller : this.fillers) {
            if (!guiFiller.getFiller().equals(filler)) continue;
            return guiFiller;
        }
        return null;
    }

    public void setFillers(List<GUIFiller<T>> fillers, boolean refresh) {
        this.fillers = fillers;
        if (refresh) {
            this.refresh();
        }
    }

    public void addFiller(GUIFiller<T> filler, boolean refresh) {
        this.fillers.add(filler);
        if (refresh) {
            this.refresh();
        }
    }

    public void addFiller(final T filler, final BiFunction<String, Language, String> formatPlaceholdersFunction, boolean refresh) {
        final FillableGUI thisGUI = this;
        this.addFiller(new GUIFiller<T>(){

            @Override
            public T getFiller() {
                return filler;
            }

            @Override
            public FillableGUI<T> getGUI() {
                return thisGUI;
            }

            @Override
            public String formatPlaceholders(String input, Language language) {
                return (String)formatPlaceholdersFunction.apply(input, language);
            }
        }, refresh);
    }

    public void removeFiller(T filler, boolean refresh) {
        GUIFiller<T> guiFiller = this.getFiller(filler);
        if (guiFiller != null) {
            this.fillers.remove(guiFiller);
        }
        if (refresh) {
            this.refresh();
        }
    }

    public void clearFillers(boolean refresh) {
        this.fillers.clear();
        if (refresh) {
            this.refresh();
        }
    }

    public List<List<Icon>> getGeneratedIcons() {
        return this.generatedIcons;
    }

    public List<Icon> getGeneratedIcons(int page) {
        try {
            return this.generatedIcons.get(page);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Map<Language, List<InventoryAdapter>> getInventories() {
        return this.inventories;
    }

    public List<InventoryAdapter> getInventories(Language language) {
        return this.inventories.get(language);
    }

    public InventoryAdapter getInventory(Language language, int page) {
        try {
            return this.getInventories(language).get(page);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Map<ChatPluginServerPlayer, Integer> getViewers() {
        return this.viewers;
    }

    public TriFunction<String, Language, Integer, String> getTitlesTranslator() {
        return this.titlesTranslator;
    }

    public FillableGUI<T> setTitlesTranslator(TriFunction<String, Language, Integer, String> titlesTranslator) {
        this.titlesTranslator = titlesTranslator;
        return this;
    }

    public FillableGUI<T> setServerTitlesTranslator() {
        this.titlesTranslator = (t, u, v) -> PlaceholderManager.getInstance().translateServerPlaceholders((String)t, (Language)u);
        return this;
    }

    public abstract boolean open(ChatPluginServerPlayer var1, int var2, boolean var3);

    public abstract boolean handleClickEvent(ChatPluginServerPlayer var1, ClickEventAdapter var2, int var3);

    public abstract boolean handleDragEvent(ChatPluginServerPlayer var1, DragEventAdapter var2, int var3);

    public abstract String getTitle(Language var1, int var2);
}

