/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.f3servername;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.f3servername.F3ServerName;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.GameFeature;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

@GameFeature(name="F3 server name", minimumSpongeVersion=VersionUtils.Version.UNSUPPORTED)
public abstract class F3ServerNameManager
implements ChatPluginManager,
Runnable {
    public static final Pattern F3_SERVER_NAME_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    public static final String CHANNEL_ID = VersionUtils.getVersion().getProtocol() > 340 ? "minecraft:brand" : "MC|Brand";
    protected static F3ServerNameManager instance;
    protected boolean enabled;
    protected boolean randomOrder;
    protected long sendingTimeout;
    protected long timerTaskID = -1L;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<F3ServerName> f3ServerNames = new CopyOnWriteArrayList<F3ServerName>();
    protected int timerIndex = -1;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<F3ServerName> getF3ServerNames() {
        return this.f3ServerNames;
    }

    public F3ServerName getF3ServerName(String id) {
        return this.f3ServerNames.stream().filter(f3ServerName -> f3ServerName.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public int getTimerIndex() {
        return this.timerIndex;
    }

    public boolean isValidF3ServerNameID(String f3ServerNameID) {
        return F3_SERVER_NAME_ID_PATTERN.matcher(f3ServerNameID).matches();
    }

    public static F3ServerNameManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract void sendF3ServerName(F3ServerName var1, ChatPluginServerPlayer var2);
}

