/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.f3servername;

import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.server.f3servername.F3ServerNameManager;
import me.remigio07.chatplugin.api.server.language.Language;

public class F3ServerName {
    private String id;
    private Map<Language, String> texts;

    public F3ServerName(String id, Map<Language, String> texts) {
        if (!F3ServerNameManager.getInstance().isValidF3ServerNameID(id)) {
            throw new IllegalArgumentException("F3 server name ID \"" + id + "\" does not respect the following pattern: \"" + F3ServerNameManager.F3_SERVER_NAME_ID_PATTERN.pattern() + "\"");
        }
        if (texts.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified map does not contain a translation for the main language");
        }
        this.id = id;
        this.texts = texts;
    }

    public String toString() {
        return "F3ServerName{id=\"" + this.id + "\"}";
    }

    public String getID() {
        return this.id;
    }

    public Map<Language, String> getTexts() {
        return this.texts;
    }

    public String getText(Language language, boolean avoidNull) {
        return this.texts.get(language) == null ? (avoidNull ? this.texts.get(Language.getMainLanguage()) : null) : this.texts.get(language);
    }
}

