/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat.channel.data;

import me.remigio07.chatplugin.api.common.telegram.TelegramBot;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannelType;
import me.remigio07.chatplugin.api.server.chat.channel.data.SocialChatChannel;
import me.remigio07.chatplugin.api.server.language.Language;

public class TelegramChatChannel
extends SocialChatChannel {
    public static final String[] PLACEHOLDERS = new String[]{"channel_telegram_chat_id", "channel_telegram_chat_title"};
    private String telegramFormat;
    private long chatID;

    public TelegramChatChannel(String minecraftFormat, String telegramFormat, long chatID) {
        super(minecraftFormat);
        this.telegramFormat = telegramFormat;
        this.chatID = chatID;
    }

    @Override
    public ChatChannelType getType() {
        return ChatChannelType.TELEGRAM;
    }

    @Override
    public String formatPlaceholders(String input, Language language) {
        return input.replace("{channel_telegram_chat_id}", String.valueOf(this.chatID)).replace("{channel_telegram_chat_title}", TelegramBot.getInstance().getChatTitle(this.chatID));
    }

    public String getTelegramFormat() {
        return this.telegramFormat;
    }

    public long getChatID() {
        return this.chatID;
    }
}

