/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat.channel;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannel;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;

public abstract class ChatChannelsManager
implements ChatPluginManager {
    public static final Pattern CHANNEL_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static ChatChannelsManager instance;
    protected boolean enabled;
    protected boolean readingNotificationEnabled;
    protected boolean spyOnJoinEnabled;
    protected String spyFormat;
    protected List<String> defaultListeningChannelsIDs = Collections.emptyList();
    protected ChatChannel<? extends ChatChannelData> defaultWritingChannel;
    protected List<ChatChannel<? extends ChatChannelData>> channels = new CopyOnWriteArrayList<ChatChannel<? extends ChatChannelData>>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSpyOnJoinEnabled() {
        return this.spyOnJoinEnabled;
    }

    public boolean isReadingNotificationEnabled() {
        return this.readingNotificationEnabled;
    }

    public String getSpyFormat() {
        return this.spyFormat;
    }

    public List<String> getDefaultListeningChannelsIDs() {
        return this.defaultListeningChannelsIDs;
    }

    public ChatChannel<? extends ChatChannelData> getDefaultWritingChannel() {
        return this.defaultWritingChannel;
    }

    public List<ChatChannel<? extends ChatChannelData>> getChannels() {
        return this.channels;
    }

    public ChatChannel<? extends ChatChannelData> getChannel(String id, boolean reckonAliases) {
        return this.channels.stream().filter(channel -> channel.getID().equalsIgnoreCase(id) || reckonAliases && Utils.arrayContains(channel.getAliases().toArray(new String[0]), id, true)).findAny().orElse(null);
    }

    public boolean isValidChannelID(String channelID) {
        return CHANNEL_ID_PATTERN.matcher(channelID).matches();
    }

    public static ChatChannelsManager getInstance() {
        return instance;
    }

    public abstract void addChannel(ChatChannel<? extends ChatChannelData> var1);
}

