/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannel;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

public abstract class PlayerPingManager
implements ChatPluginManager {
    protected static PlayerPingManager instance;
    protected boolean enabled;
    protected boolean atSignRequired;
    protected boolean soundEnabled;
    protected boolean titlesEnabled;
    protected long perPlayerCooldown;
    protected long titlesFadeIn;
    protected long titlesStay;
    protected long titlesFadeOut;
    protected String color;
    protected SoundAdapter sound;
    protected Map<Language, String> titles = new HashMap<Language, String>();
    protected Map<Language, String> subtitles = new HashMap<Language, String>();
    protected Set<UUID> playersOnCooldown = new HashSet<UUID>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAtSignRequired() {
        return this.atSignRequired;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public boolean areTitlesEnabled() {
        return this.titlesEnabled;
    }

    public long getPerPlayerCooldown() {
        return this.perPlayerCooldown;
    }

    public long getTitlesFadeIn() {
        return this.titlesFadeIn;
    }

    public long getTitlesStay() {
        return this.titlesStay;
    }

    public long getTitlesFadeOut() {
        return this.titlesFadeOut;
    }

    public String getColor() {
        return this.color;
    }

    public SoundAdapter getSound() {
        return this.sound;
    }

    public Map<Language, String> getTitles() {
        return this.titles;
    }

    public String getTitle(Language language, boolean avoidNull) {
        return this.titles.get(language) == null ? (avoidNull ? this.titles.get(Language.getMainLanguage()) : null) : this.titles.get(language);
    }

    public Map<Language, String> getSubtitles() {
        return this.subtitles;
    }

    public String getSubtitle(Language language, boolean avoidNull) {
        return this.subtitles.get(language) == null ? (avoidNull ? this.subtitles.get(Language.getMainLanguage()) : null) : this.subtitles.get(language);
    }

    public Set<UUID> getPlayersOnCooldown() {
        return this.playersOnCooldown;
    }

    public static PlayerPingManager getInstance() {
        return instance;
    }

    public abstract String performPing(ChatPluginServerPlayer var1, String var2, ChatChannel<? extends ChatChannelData> var3, List<ChatPluginServerPlayer> var4);

    public abstract List<ChatPluginServerPlayer> getPingedPlayers(ChatPluginServerPlayer var1, String var2, ChatChannel<? extends ChatChannelData> var3);

    public abstract void playPingSound(ChatPluginServerPlayer var1);
}

