/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.bossbar;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.bossbar.Bossbar;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.GameFeature;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

@GameFeature(name="bossbar", minimumSpongeVersion=VersionUtils.Version.V1_9)
public abstract class BossbarManager
implements ChatPluginManager,
Runnable {
    public static final Pattern BOSSBAR_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    public static final int MAX_TITLE_LENGTH = VersionUtils.getVersion().getProtocol() > 340 ? 256 : 64;
    public static final String TITLE_TOO_LONG = "\u00a7cTitle exceeds \u00a7f64 \u00a7cchars";
    protected static BossbarManager instance;
    protected boolean enabled;
    protected boolean randomOrder;
    protected boolean abbreviateLongTitles;
    protected boolean sendFullToLegacyPlayers;
    protected boolean loadingBossbarEnabled;
    protected double reflectionWitherTeleportationDistance;
    protected long reflectionWitherTeleportationTimeout;
    protected long sendingTimeout;
    protected long loadingBossbarSendingTimeout;
    protected long timerTaskID = -1L;
    protected long reflectionTimerTaskID = -1L;
    protected long lastRunTime = -1L;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<String> enabledWorlds = Collections.emptyList();
    protected List<Bossbar> bossbars = new CopyOnWriteArrayList<Bossbar>();
    protected Map<ChatPluginServerPlayer, Long> loadingBossbarsTasks = new ConcurrentHashMap<ChatPluginServerPlayer, Long>();
    protected ReflectionBossbarTimer reflectionBossbarTimer;
    protected int timerIndex = -1;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public boolean shouldAbbreviateLongTitles() {
        return this.abbreviateLongTitles;
    }

    public boolean shouldSendFullToLegacyPlayers() {
        return this.sendFullToLegacyPlayers;
    }

    public boolean isLoadingBossbarEnabled() {
        return this.loadingBossbarEnabled;
    }

    public double getReflectionWitherTeleportationDistance() {
        return this.reflectionWitherTeleportationDistance;
    }

    public long getReflectionWitherTeleportationTimeout() {
        return this.reflectionWitherTeleportationTimeout;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    public long getLoadindBossbarSendingTimeout() {
        return this.loadingBossbarSendingTimeout;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isWorldEnabled(String world) {
        return this.enabledWorlds.contains("*") || this.enabledWorlds.contains(world);
    }

    public List<Bossbar> getBossbars() {
        return this.bossbars;
    }

    public Map<ChatPluginServerPlayer, Long> getLoadingBossbarsTasks() {
        return this.loadingBossbarsTasks;
    }

    public Bossbar getBossbar(String id) {
        return this.bossbars.stream().filter(bossbar -> bossbar.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public ReflectionBossbarTimer getReflectionBossbarTimer() {
        return this.reflectionBossbarTimer;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public long getReflectionTimerTaskID() {
        return this.reflectionTimerTaskID;
    }

    public int getTimerIndex() {
        return this.timerIndex;
    }

    public long getLastRunTime() {
        return this.lastRunTime;
    }

    public boolean isValidBossbarID(String bossbarID) {
        return BOSSBAR_ID_PATTERN.matcher(bossbarID).matches();
    }

    public static BossbarManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract void sendBossbar(Bossbar var1, ChatPluginServerPlayer var2);

    public abstract void startLoading(ChatPluginServerPlayer var1);

    public abstract class ReflectionBossbarTimer
    extends TimerTask {
        @Override
        public abstract void run();
    }
}

