/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.bossbar;

import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.common.util.ValueContainer;
import me.remigio07.chatplugin.api.server.bossbar.BossbarManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.adapter.bossbar.BossbarColorAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.bossbar.BossbarStyleAdapter;

public class Bossbar {
    private String id;
    private Map<Language, String> titles;
    private ValueContainer<Double> value;
    private ValueContainer<Double> maxValue;
    private BossbarColorAdapter color;
    private BossbarStyleAdapter style;
    private boolean hidden;

    public Bossbar(String id, Map<Language, String> titles, ValueContainer<Double> value, ValueContainer<Double> maxValue, BossbarColorAdapter color, BossbarStyleAdapter style, boolean hidden) {
        if (!BossbarManager.getInstance().isValidBossbarID(id)) {
            throw new IllegalArgumentException("Bossbar ID \"" + id + "\" does not respect the following pattern: \"" + BossbarManager.BOSSBAR_ID_PATTERN.pattern() + "\"");
        }
        if (titles.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified map does not contain a translation for the main language");
        }
        this.id = id;
        this.titles = titles;
        this.value = value;
        this.maxValue = maxValue;
        this.color = color;
        this.style = style;
        this.hidden = hidden;
    }

    public String toString() {
        return "Bossbar{id=\"" + this.id + "\"}";
    }

    public String getID() {
        return this.id;
    }

    public Map<Language, String> getTitles() {
        return this.titles;
    }

    public String getTitle(Language language, boolean avoidNull) {
        return this.titles.get(language) == null ? (avoidNull ? this.titles.get(Language.getMainLanguage()) : null) : this.titles.get(language);
    }

    public ValueContainer<Double> getValue() {
        return this.value;
    }

    public Bossbar setValue(ValueContainer<Double> value) {
        this.value = value;
        return this;
    }

    public ValueContainer<Double> getMaxValue() {
        return this.maxValue;
    }

    public Bossbar setMaxValue(ValueContainer<Double> maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public BossbarColorAdapter getColor() {
        return this.color;
    }

    public Bossbar setColor(BossbarColorAdapter color) {
        this.color = color;
        return this;
    }

    public BossbarStyleAdapter getStyle() {
        return this.style;
    }

    public Bossbar setStyle(BossbarStyleAdapter style) {
        this.style = style;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Bossbar setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }
}

