/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.ad;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.ad.Ad;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

public abstract class AdManager
implements ChatPluginManager,
Runnable {
    public static final Pattern AD_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static AdManager instance;
    protected boolean enabled;
    protected boolean randomOrder;
    protected boolean hasPrefix;
    protected boolean soundEnabled;
    protected String prefix;
    protected SoundAdapter sound;
    protected long sendingTimeout;
    protected long timerTaskID = -1L;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<Ad> ads = new CopyOnWriteArrayList<Ad>();
    protected int timerIndex = -1;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public boolean hasPrefix() {
        return this.hasPrefix;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public SoundAdapter getSound() {
        return this.sound;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<Ad> getAds() {
        return this.ads;
    }

    public Ad getAd(String id) {
        return this.ads.stream().filter(ad -> ad.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public int getTimerIndex() {
        return this.timerIndex;
    }

    public boolean isValidAdID(String adID) {
        return AD_ID_PATTERN.matcher(adID).matches();
    }

    public static AdManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract void sendAd(Ad var1, ChatPluginServerPlayer var2);
}

