/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.proxy.util.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.proxy.event.socket.ServerShutdownEvent;
import me.remigio07.chatplugin.api.proxy.event.socket.ServerStartupEvent;
import me.remigio07.chatplugin.api.proxy.util.socket.ClientHandler;

public class Server
extends Thread {
    private ServerSocket socket;
    private List<ClientHandler> clientHandlers = new ArrayList<ClientHandler>();

    public Server(InetAddress address, int port) throws IOException {
        this.socket = new ServerSocket(port, 50, address);
    }

    @Override
    public synchronized void start() {
        if (this.socket.isClosed()) {
            return;
        }
        LogManager.log("[SOCKETS] New server started up; listening on {0}...", 4, this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getLocalPort());
        super.start();
        new ServerStartupEvent(this).call();
    }

    @Override
    @Deprecated
    public void run() {
        try {
            while (true) {
                Socket client = this.socket.accept();
                LogManager.log("[SOCKETS] Connection accepted from client {0}; waiting for the ID to identify it...", 4, client.getInetAddress().getHostAddress() + ":" + client.getPort());
                new ClientHandler(this, client);
            }
        }
        catch (SocketException client) {
        }
        catch (IOException e) {
            LogManager.log("[SOCKETS] IOException occurred while waiting for new connections on {0}: {1}", 2, this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getLocalPort(), e.getMessage());
        }
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", "Server{", "}").add("address=" + this.socket.getInetAddress().getHostAddress()).add("port=" + this.socket.getLocalPort()).toString();
    }

    public void shutdown() throws IOException {
        if (this.socket.isClosed()) {
            return;
        }
        LogManager.log("[SOCKETS] Server shut down; closing {0} connections...", 4, this.clientHandlers.size());
        new ServerShutdownEvent(this).call();
        for (ClientHandler clientHandler : this.clientHandlers) {
            clientHandler.disconnect("Server shutdown");
        }
        this.socket.close();
    }

    public ServerSocket getSocket() {
        return this.socket;
    }

    public List<ClientHandler> getClientHandlers() {
        return this.clientHandlers;
    }
}

