/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.proxy.util.manager;

import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.util.ServerInformation;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.common.util.packet.PacketSerializer;

public abstract class ProxyMessageManager
implements ChatPluginManager {
    protected static ProxyMessageManager instance;
    protected boolean enabled;
    protected Map<String, ServerInformation> serversInformation = new ConcurrentHashMap<String, ServerInformation>();
    protected Map<String, Queue<PacketSerializer>> packetsQueue = new ConcurrentHashMap<String, Queue<PacketSerializer>>();
    protected long taskID;
    protected long loadTime;

    @Override
    public void load() throws ChatPluginManagerException {
        instance = this;
        long ms = System.currentTimeMillis();
        this.taskID = TaskManager.scheduleAsync(() -> {
            for (String server : new HashSet<String>(this.serversInformation.keySet())) {
                if (this.serversInformation.get(server).getLastEdit() >= System.currentTimeMillis() - 31000L) continue;
                this.serversInformation.remove(server);
            }
        }, 0L, 5000L);
        this.enabled = true;
        this.loadTime = System.currentTimeMillis() - ms;
    }

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        TaskManager.cancelAsync(this.taskID);
        this.serversInformation.clear();
        this.packetsQueue.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isReloadable() {
        return false;
    }

    public Map<String, ServerInformation> getServersInformation() {
        return this.serversInformation;
    }

    public int getOnlinePlayers(String server, boolean hideVanished) {
        if (server.equals("ALL")) {
            int total = 0;
            for (ServerInformation info : this.serversInformation.values()) {
                total += info.getOnlinePlayers() - (hideVanished ? info.getVanishedPlayers() : 0);
            }
            return total;
        }
        return this.serversInformation.containsKey(server) ? this.serversInformation.get(server).getOnlinePlayers() - (hideVanished ? this.serversInformation.get(server).getVanishedPlayers() : 0) : 0;
    }

    public int getVanishedPlayers(String server) {
        if (server.equals("ALL")) {
            int total = 0;
            for (ServerInformation info : this.serversInformation.values()) {
                total += info.getVanishedPlayers();
            }
            return total;
        }
        return this.serversInformation.containsKey(server) ? this.serversInformation.get(server).getVanishedPlayers() : 0;
    }

    public String formatOnlineAndVanishedPlaceholders(String input, boolean hideVanished) {
        for (ServerInformation info : this.serversInformation.values()) {
            input = input.replace("{online@" + info.getID() + "}", String.valueOf(info.getOnlinePlayers() - (hideVanished ? info.getVanishedPlayers() : 0))).replace("{vanished@" + info.getID() + "}", String.valueOf(info.getVanishedPlayers()));
        }
        return input;
    }

    @Deprecated
    public Map<String, Queue<PacketSerializer>> getPacketsQueue() {
        return this.packetsQueue;
    }

    public static ProxyMessageManager getInstance() {
        return instance;
    }

    public abstract void sendPluginMessage(String var1, PacketSerializer var2);

    public abstract void sendOrQueuePluginMessage(String var1, PacketSerializer var2, long var3);
}

