/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.proxy.player;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.proxy.player.ChatPluginProxyPlayer;

public abstract class ProxyPlayerManager
extends PlayerManager {
    protected Map<UUID, ChatPluginProxyPlayer> players = new ConcurrentHashMap<UUID, ChatPluginProxyPlayer>();

    @Override
    public void load() throws ChatPluginManagerException {
        instance = this;
        long ms = System.currentTimeMillis();
        if (IntegrationType.FLOODGATE.isEnabled()) {
            this.floodgateUsernamePrefix = IntegrationType.FLOODGATE.get().getUsernamePrefix();
            if (this.floodgateUsernamePrefix.isEmpty()) {
                LogManager.log("Floodgate is installed but the username prefix set at \"username-prefix\" in its config.yml is empty: this is not recommended as ChatPlugin will not be able to distinguish Java players from Bedrock ones.", 1, new Object[0]);
            } else if (!Pattern.matches("^[^ \\w]$", this.floodgateUsernamePrefix)) {
                throw new ChatPluginManagerException(this, "invalid Floodgate username prefix ({0}) set at \"username-prefix\" in Floodgate's config.yml: it cannot be longer than 1 character and cannot be a letter, a number, a space or an underscore", this.floodgateUsernamePrefix);
            }
        } else {
            this.floodgateUsernamePrefix = "";
        }
        super.load();
        this.enabled = true;
        this.loadTime = System.currentTimeMillis() - ms;
    }

    @Override
    public void unload() {
        this.enabled = false;
        this.players.keySet().forEach(this::unloadPlayer);
        this.players.clear();
        super.unload();
    }

    public Map<UUID, ChatPluginProxyPlayer> getPlayers() {
        return this.players;
    }

    public List<ChatPluginProxyPlayer> getPlayers(InetAddress ipAddress) {
        return this.players.values().stream().filter(player -> player.getIPAddress().equals(ipAddress)).collect(Collectors.toList());
    }

    @Override
    public ChatPluginProxyPlayer getPlayer(UUID uuid) {
        return this.players.get(uuid);
    }

    @Override
    @Deprecated
    public ChatPluginProxyPlayer getPlayer(String name, boolean checkPattern, boolean ignoreCase) {
        if (!this.isValidUsername(name)) {
            throw new IllegalArgumentException("Username \"" + name + "\" does not respect the following pattern: \"" + this.usernamePattern.pattern() + "\"");
        }
        for (ChatPluginProxyPlayer player : this.getPlayers().values()) {
            if (!(ignoreCase ? player.getName().equalsIgnoreCase(name) : player.getName().equals(name))) continue;
            return player;
        }
        return null;
    }

    public static ProxyPlayerManager getInstance() {
        return (ProxyPlayerManager)instance;
    }

    public abstract int loadPlayer(PlayerAdapter var1);

    public abstract int unloadPlayer(UUID var1);
}

