/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.manager;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.bootstrap.BukkitBootstrapper;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import me.remigio07.chatplugin.bootstrap.SpongeBootstrapper;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;

public abstract class TaskManager
implements ChatPluginManager {
    protected static TaskManager instance;
    protected boolean enabled;
    protected ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    protected ExecutorService executor = Executors.newCachedThreadPool();
    protected Map<Long, Object> syncTasks = new ConcurrentHashMap<Long, Object>();
    protected Map<Long, ScheduledFuture<?>> asyncTasks = new ConcurrentHashMap();
    protected AtomicLong currentSyncID;
    protected AtomicLong currentAsyncID = new AtomicLong();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ExecutorService getScheduler() {
        return this.scheduler;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Set<Long> getSyncTasks() {
        return this.syncTasks.keySet();
    }

    public Map<Long, ScheduledFuture<?>> getAsyncTasks() {
        return this.asyncTasks;
    }

    public AtomicLong getCurrentSyncID() {
        return this.currentSyncID;
    }

    public AtomicLong getCurrentAsyncID() {
        return this.currentAsyncID;
    }

    public static long runSync(Runnable runnable, long delay) {
        if (Environment.isProxy()) {
            throw new UnsupportedOperationException("Synchronous tasks are not available on a " + Environment.getCurrent().getName() + " environment");
        }
        delay = delay < 0L ? 0L : delay;
        long taskID = Environment.isBukkit() ? (long)BukkitScheduler.runSync(runnable, delay) : TaskManager.instance.currentSyncID.getAndIncrement();
        TaskManager.instance.syncTasks.put(taskID, Environment.isBukkit() ? Integer.valueOf(-1) : (Environment.isSponge() ? Sponge.getScheduler().createTaskBuilder().execute(runnable).delayTicks(delay / 50L).submit((Object)SpongeBootstrapper.getInstance()).getUniqueId() : TaskManager.instance.scheduler.schedule(() -> FabricBootstrapper.getInstance().getServer().execute(runnable), delay, TimeUnit.MILLISECONDS)));
        TaskManager.runAsync(() -> TaskManager.instance.syncTasks.remove(taskID), delay);
        return taskID;
    }

    public static long runAsync(Runnable runnable, long delay) {
        long taskID = TaskManager.instance.currentAsyncID.getAndIncrement();
        TaskManager.instance.asyncTasks.put(taskID, TaskManager.instance.scheduler.schedule(() -> TaskManager.instance.executor.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LogManager.log("{0} occurred while executing an asynchronous task (delay: {1} ms): {2}", 2, t.getClass().getSimpleName(), delay, t.getLocalizedMessage());
                t.printStackTrace();
            }
            TaskManager.instance.asyncTasks.remove(taskID);
        }), delay < 0L ? 0L : delay, TimeUnit.MILLISECONDS));
        return taskID;
    }

    public static long scheduleSync(Runnable runnable, long delay, long period) {
        if (Environment.isProxy()) {
            throw new UnsupportedOperationException("Synchronous tasks are not available on a " + Environment.getCurrent().getName() + " environment");
        }
        delay = delay < 0L ? 0L : delay;
        period = period < 1L ? 1L : period;
        long taskID = Environment.isBukkit() ? (long)BukkitScheduler.scheduleSync(runnable, delay, period) : TaskManager.instance.currentSyncID.getAndIncrement();
        TaskManager.instance.syncTasks.put(taskID, Environment.isBukkit() ? Integer.valueOf(-1) : (Environment.isSponge() ? Sponge.getScheduler().createTaskBuilder().execute(runnable).delayTicks(delay / 50L).intervalTicks(period / 50L).submit((Object)SpongeBootstrapper.getInstance()).getUniqueId() : TaskManager.instance.scheduler.scheduleAtFixedRate(() -> FabricBootstrapper.getInstance().getServer().execute(runnable), delay, period, TimeUnit.MILLISECONDS)));
        return taskID;
    }

    public static long scheduleAsync(Runnable runnable, long delay, long period) {
        long taskID = TaskManager.instance.currentAsyncID.getAndIncrement();
        TaskManager.instance.asyncTasks.put(taskID, TaskManager.instance.scheduler.scheduleWithFixedDelay(() -> TaskManager.instance.executor.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LogManager.log("{0} occurred while executing an asynchronous repeating task (delay: {1} ms, period: {2} ms): {3}", 2, t.getClass().getSimpleName(), delay, period, t.getLocalizedMessage());
                t.printStackTrace();
            }
        }), delay < 0L ? 0L : delay, period < 1L ? 1L : period, TimeUnit.MILLISECONDS));
        return taskID;
    }

    public static void cancelSync(long id) {
        if (TaskManager.instance.syncTasks.containsKey(id)) {
            if (Environment.isBukkit()) {
                Bukkit.getScheduler().cancelTask((int)id);
            } else if (Environment.isSponge()) {
                ((Task)Sponge.getScheduler().getTaskById((UUID)TaskManager.instance.syncTasks.get(id)).get()).cancel();
            } else {
                ((ScheduledFuture)TaskManager.instance.syncTasks.get(id)).cancel(false);
            }
            TaskManager.instance.syncTasks.remove(id);
        }
    }

    public static void cancelAsync(long id) {
        if (TaskManager.instance.asyncTasks.containsKey(id)) {
            TaskManager.instance.asyncTasks.remove(id).cancel(false);
        }
    }

    public static TaskManager getInstance() {
        return instance;
    }

    protected static class BukkitScheduler {
        protected BukkitScheduler() {
        }

        public static int runSync(Runnable runnable, long delay) {
            return Bukkit.getScheduler().runTaskLater((Plugin)BukkitBootstrapper.getInstance(), runnable, (delay < 0L ? 0L : delay) / 50L).getTaskId();
        }

        public static int scheduleSync(Runnable runnable, long delay, long period) {
            return Bukkit.getScheduler().runTaskTimer((Plugin)BukkitBootstrapper.getInstance(), runnable, (delay < 0L ? 0L : delay) / 50L, (period < 1L ? 1L : period) / 50L).getTaskId();
        }

        public static void cancelTasks() {
            Bukkit.getScheduler().cancelTasks((Plugin)BukkitBootstrapper.getInstance());
        }
    }
}

