/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.manager;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.MemoryUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;

public abstract class LogManager
implements ChatPluginManager {
    protected static LogManager instance;
    protected boolean enabled;
    protected Boolean debug = null;
    protected LoggerType loggerType;
    protected Path file;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("[MM-dd HH:mm:ss]: ");
    protected long loadTime;

    @Override
    public void load() throws ChatPluginManagerException {
        try {
            this.file = ChatPlugin.getInstance().getDataFolder().resolve("chatplugin.log");
            if (!Files.exists(this.file, new LinkOption[0])) {
                Files.createFile(this.file, new FileAttribute[0]);
            } else if (Files.size(this.file) > (long)(10 * MemoryUtils.MEGABYTE.getToBytesRatio())) {
                this.logMessage("Log file chatplugin.log's size is over 10 MB (currently " + MemoryUtils.formatMemory(Files.size(this.file), MemoryUtils.MEGABYTE) + " MB). This might impact performance. It is recommended to stop the server and rename or delete the file before starting again.", LogLevel.WARNING, new Object[0]);
            }
        }
        catch (IOException ioe) {
            throw new ChatPluginManagerException(this, (Exception)ioe);
        }
        this.enabled = true;
    }

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        this.debug = null;
        this.loggerType = null;
        this.file = null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDebug() {
        return this.debug == null ? false : this.debug;
    }

    public LoggerType getLoggerType() {
        return this.loggerType;
    }

    public void setLoggerType(LoggerType loggerType) {
        this.loggerType = loggerType;
    }

    public void setDebug(boolean debug) throws IOException {
        if (this.debug == null) {
            this.debug = debug;
        }
        if (this.debug == debug) {
            return;
        }
        Configuration config = ConfigurationType.CONFIG.get();
        this.debug = debug;
        config.set("settings.debug", debug);
        config.save();
        this.logMessage("Debug mode " + (debug ? "enabled" : "disabled") + ".", LogLevel.INFO, new Object[0]);
    }

    public Path getFile() {
        return this.file;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void writeToFile(String message) {
        if (this.file == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardOpenOption.APPEND);){
            writer.write(this.dateFormat.format(new Date()) + ChatColor.stripColor(message) + "\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void log(String message, int logLevel, Object ... args) {
        instance.logMessage(message, LogLevel.values()[logLevel < 0 || logLevel > 4 ? 0 : logLevel], args);
    }

    public static LogManager getInstance() {
        return instance;
    }

    public abstract void logMessage(String var1, LogLevel var2, Object ... var3);

    public static enum LogLevel {
        INFO("[INFO] "),
        WARNING("[WARN] "),
        ERROR("[ERROR] "),
        DEBUG("[DEBUG] "),
        DEBUG_FILE("[DEBUG] ");

        private String prefix;

        private LogLevel(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean shouldBeSent() {
            return this != DEBUG_FILE && (this != DEBUG || LogManager.getInstance().isDebug());
        }
    }

    public static enum LoggerType {
        JAVA,
        SLF4J;

    }
}

