/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.adapter.user;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.player.ChatPluginPlayer;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import me.remigio07.chatplugin.bootstrap.VelocityBootstrapper;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;

public class PlayerAdapter {
    private static final Set<String> FABRIC_PERMISSIONS = Environment.isFabric() ? Stream.concat(Stream.of("chatplugin.player-ping"), Stream.of("chatplugin", "help", "info", "version", "language", "whisper", "reply", "chatchannel", "chatchannel.join", "chatchannel.leave", "chatchannel.switch", "chatchannel.info", "chatchannel.list", "ignore", "ignore.add", "ignore.remove", "ignore.clear", "ignore.list", "ping", "ping.others", "rankinfo", "playerlist", "emojistone", "preferences").map(str -> "chatplugin.commands." + str)).collect(Collectors.toSet()) : null;
    private Object player;

    public PlayerAdapter(Object player) {
        this.player = player;
    }

    public int hashCode() {
        return ChatPlugin.getInstance().isOnlineMode() ? this.getUUID().hashCode() : (this.getName() == null ? -1 : this.getName().hashCode());
    }

    public boolean equals(Object obj) {
        return obj instanceof PlayerAdapter ? (ChatPlugin.getInstance().isOnlineMode() ? ((PlayerAdapter)obj).getUUID().equals(this.getUUID()) : (((PlayerAdapter)obj).getName() == null ? false : ((PlayerAdapter)obj).getName().equalsIgnoreCase(this.getName()))) : false;
    }

    public String toString() {
        return new StringJoiner(", ", "PlayerAdapter{", "}").add("uuid=" + this.getUUID().toString()).add("name=\"" + this.getName() + "\"").toString();
    }

    public org.bukkit.entity.Player bukkitValue() {
        if (Environment.isBukkit()) {
            return (org.bukkit.entity.Player)this.player;
        }
        throw new UnsupportedOperationException("Unable to adapt player to a Bukkit's Player on a " + Environment.getCurrent().getName() + " environment");
    }

    public Player spongeValue() {
        if (Environment.isSponge()) {
            return (Player)this.player;
        }
        throw new UnsupportedOperationException("Unable to adapt text to a Sponge's Player on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_3222 fabricValue() {
        if (Environment.isFabric()) {
            return (class_3222)this.player;
        }
        throw new UnsupportedOperationException("Unable to adapt text to a Fabric's ServerPlayerEntity on a " + Environment.getCurrent().getName() + " environment");
    }

    public ProxiedPlayer bungeeCordValue() {
        if (Environment.isBungeeCord()) {
            return (ProxiedPlayer)this.player;
        }
        throw new UnsupportedOperationException("Unable to adapt text to a BungeeCord's TextComponent on a " + Environment.getCurrent().getName() + " environment");
    }

    public com.velocitypowered.api.proxy.Player velocityValue() {
        if (Environment.isVelocity()) {
            return (com.velocitypowered.api.proxy.Player)this.player;
        }
        throw new UnsupportedOperationException("Unable to adapt text to a Velocity's Component on a " + Environment.getCurrent().getName() + " environment");
    }

    public ChatPluginPlayer chatPluginValue() {
        return this.isLoaded() ? PlayerManager.getInstance().getPlayer(this.getUUID()) : null;
    }

    public UUID getUUID() {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                return this.bukkitValue().getUniqueId();
            }
            case SPONGE: {
                return this.spongeValue().getUniqueId();
            }
            case FABRIC: {
                return this.fabricValue().method_5667();
            }
            case BUNGEECORD: {
                return this.bungeeCordValue().getUniqueId();
            }
            case VELOCITY: {
                return this.velocityValue().getUniqueId();
            }
        }
        return null;
    }

    public String getName() {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                return this.bukkitValue().getName();
            }
            case SPONGE: {
                return this.spongeValue().getName();
            }
            case FABRIC: {
                return this.fabricValue().method_5477().getString();
            }
            case BUNGEECORD: {
                return this.bungeeCordValue().getName();
            }
            case VELOCITY: {
                return this.velocityValue().getUsername();
            }
        }
        return null;
    }

    public InetAddress getIPAddress() {
        SocketAddress address = null;
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                address = this.bukkitValue().getAddress();
                break;
            }
            case SPONGE: {
                address = this.spongeValue().getConnection().getAddress();
                break;
            }
            case FABRIC: {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_19_4)) {
                    try {
                        address = ((class_2535)class_3244.class.getField("field_14127").get(this.fabricValue().field_13987)).method_10755();
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                address = this.fabricValue().field_13987.method_48107();
                break;
            }
            case BUNGEECORD: {
                address = this.bungeeCordValue().getSocketAddress();
                break;
            }
            case VELOCITY: {
                address = this.velocityValue().getRemoteAddress();
            }
        }
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getAddress() : InetAddress.getLoopbackAddress();
    }

    public boolean isLoaded() {
        return PlayerManager.getInstance().getPlayer(this.getUUID()) != null;
    }

    public boolean hasPermission(String permission) {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                return this.bukkitValue().hasPermission(permission);
            }
            case SPONGE: {
                return this.spongeValue().hasPermission(permission);
            }
            case FABRIC: {
                if (IntegrationType.LUCKPERMS.isEnabled()) {
                    return IntegrationType.LUCKPERMS.get().hasPermission(new OfflinePlayer(this), permission);
                }
                try {
                    if (FABRIC_PERMISSIONS.contains(permission)) {
                        return true;
                    }
                    return VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_9) ? FabricBootstrapper.getInstance().getServer().method_3760().method_14569(this.fabricValue().method_72498()) : ((Boolean)class_3324.class.getMethod("method_14569", GameProfile.class).invoke((Object)FabricBootstrapper.getInstance().getServer().method_3760(), this.fabricValue().method_7334())).booleanValue();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case BUNGEECORD: {
                return this.bungeeCordValue().hasPermission(permission);
            }
            case VELOCITY: {
                return this.velocityValue().hasPermission(permission);
            }
        }
        return false;
    }

    public void sendMessage(String message) {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                this.bukkitValue().sendMessage(message);
                break;
            }
            case SPONGE: {
                this.spongeValue().sendMessage(Utils.toSpongeComponent(message));
                break;
            }
            case FABRIC: {
                this.fabricValue().method_64398(Utils.toFabricComponent(message));
                break;
            }
            case BUNGEECORD: {
                this.bungeeCordValue().sendMessage(message);
                break;
            }
            case VELOCITY: {
                this.velocityValue().sendMessage(Utils.toAdventureComponent(message));
            }
        }
    }

    public void disconnect(String reason) {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                this.bukkitValue().kickPlayer(reason);
                break;
            }
            case SPONGE: {
                this.spongeValue().kick(Utils.toSpongeComponent(reason));
                break;
            }
            case FABRIC: {
                this.fabricValue().field_13987.method_52396(Utils.toFabricComponent(reason));
                break;
            }
            case BUNGEECORD: {
                this.bungeeCordValue().disconnect(reason);
                break;
            }
            case VELOCITY: {
                this.velocityValue().disconnect(Utils.toAdventureComponent(reason));
            }
        }
    }

    public static PlayerAdapter getPlayer(UUID uuid) {
        org.bukkit.entity.Player player = null;
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                player = Bukkit.getPlayer((UUID)uuid);
                break;
            }
            case SPONGE: {
                player = Sponge.getServer().getPlayer(uuid).orElse(null);
                break;
            }
            case FABRIC: {
                player = FabricBootstrapper.getInstance().getServer().method_3760().method_14602(uuid);
                break;
            }
            case BUNGEECORD: {
                player = ProxyServer.getInstance().getPlayer(uuid);
                break;
            }
            case VELOCITY: {
                player = VelocityBootstrapper.getInstance().getProxy().getPlayer(uuid).orElse(null);
            }
        }
        return player == null ? null : new PlayerAdapter(player);
    }

    public static PlayerAdapter getPlayer(String name, boolean checkPattern) {
        if (checkPattern && !PlayerManager.getInstance().isValidUsername(name)) {
            throw new IllegalArgumentException("Username \"" + name + "\" does not respect the following pattern: \"" + PlayerManager.getInstance().getUsernamePattern().pattern() + "\"");
        }
        org.bukkit.entity.Player player = null;
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                player = Bukkit.getPlayerExact((String)name);
                break;
            }
            case SPONGE: {
                player = Sponge.getServer().getPlayer(name).orElse(null);
                break;
            }
            case FABRIC: {
                player = FabricBootstrapper.getInstance().getServer().method_3760().method_14566(name);
                break;
            }
            case BUNGEECORD: {
                player = ProxyServer.getInstance().getPlayer(name);
                break;
            }
            case VELOCITY: {
                player = VelocityBootstrapper.getInstance().getProxy().getPlayer(name).orElse(null);
            }
        }
        return player == null ? null : new PlayerAdapter(player);
    }

    public static List<PlayerAdapter> getOnlinePlayers() {
        List<org.bukkit.entity.Player> players = null;
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                try {
                    players = Arrays.asList((org.bukkit.entity.Player[])Server.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]));
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
                    players = Bukkit.getOnlinePlayers();
                }
                break;
            }
            case SPONGE: {
                players = Sponge.getServer().getOnlinePlayers();
                break;
            }
            case FABRIC: {
                players = FabricBootstrapper.getInstance().getServer().method_3760().method_14571();
                break;
            }
            case BUNGEECORD: {
                players = ProxyServer.getInstance().getPlayers();
                break;
            }
            case VELOCITY: {
                players = VelocityBootstrapper.getInstance().getProxy().getAllPlayers();
            }
        }
        return players.stream().map(PlayerAdapter::new).collect(Collectors.toList());
    }
}

