/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import com.velocitypowered.api.network.ProtocolVersion;
import java.util.Optional;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.VelocityBootstrapper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.md_5.bungee.api.ProxyServer;
import org.bukkit.Bukkit;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;

public class VersionUtils {
    private static Version version;
    private static String implementationVersion;
    private static String implementationName;
    private static String nmsVersion;
    private static String[] spongeImplementations;

    @Deprecated
    public static void initVersionUtils() throws ChatPluginManagerException {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                version = Version.getVersion(Bukkit.getBukkitVersion().substring(0, Bukkit.getBukkitVersion().indexOf(45)));
                implementationVersion = Bukkit.getVersion();
                String string = VersionUtils.isArclight() ? "\u00a73Arc\u00a7elight" : (VersionUtils.isPurpur() ? "\u00a75Purpur" : (VersionUtils.isPaper() ? "\u00a7fPaper" : (implementationName = VersionUtils.isSpigot() ? "\u00a76Spigot" : "\u00a77Craft\u00a76Bukkit")));
                if (version == Version.UNSUPPORTED || VersionUtils.isPaper() && !version.isOlderThan(Version.V1_20_5)) break;
                nmsVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
                break;
            }
            case SPONGE: {
                version = Version.getVersion(Sponge.getPlatform().getMinecraftVersion().getName());
                implementationVersion = (String)((PluginContainer)Sponge.getPluginManager().getPlugin("spongeapi").get()).getVersion().get();
                implementationName = spongeImplementations[(Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getId().length() - 9) / 2];
                break;
            }
            case FABRIC: {
                version = Version.getVersion(FabricLoader.getInstance().getRawGameVersion());
                ModContainer mod = FabricLoader.getInstance().getModContainer("fabric-api").map(Optional::of).orElseGet(() -> FabricLoader.getInstance().getModContainer("fabric")).orElse(null);
                try {
                    if (mod == null || mod.getMetadata().getVersion().compareTo((Object)net.fabricmc.loader.api.Version.parse((String)"0.28.5")) < 0) {
                        throw new ChatPluginManagerException("version utils", "Fabric API (v0.28.5 or newer) is required to run ChatPlugin", new Object[0]);
                    }
                    implementationVersion = mod.getMetadata().getVersion().getFriendlyString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                implementationName = "\u00a7fFabric";
                break;
            }
            case BUNGEECORD: {
                version = Version.getVersion(ProxyServer.getInstance().getProtocolVersion(), false);
                implementationVersion = ProxyServer.getInstance().getVersion();
                implementationName = VersionUtils.isFlameCord() ? "\u00a7cFlameCord" : (VersionUtils.isWaterfall() ? "\u00a79Waterfall" : "\u00a76BungeeCord");
                break;
            }
            case VELOCITY: {
                version = Version.getVersion(ProtocolVersion.MAXIMUM_VERSION.getName());
                implementationVersion = VelocityBootstrapper.getInstance().getProxy().getVersion().getVersion();
                implementationName = "\u00a7bVelocity";
            }
        }
        if (version.isOlderThan(Version.V1_8)) {
            throw new ChatPluginManagerException("version utils", "This version is older than 1.8. Compatible versions: 1.8-{0}. Support for older versions will be added over time, but it is not a priority", Version.values()[Version.values().length - 2].getName());
        }
    }

    public static Version getVersion() {
        return version;
    }

    public static String getNMSVersion() {
        return nmsVersion;
    }

    public static String getImplementationVersion() {
        return implementationVersion;
    }

    public static String getImplementationName() {
        return implementationName;
    }

    public static boolean isSpigot() {
        try {
            Class.forName("org.bukkit.entity.Player$Spigot");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPaper() {
        try {
            Class.forName((version.isAtLeast(Version.V1_9) ? "com.destroystokyo.paper" : "org.github.paperspigot") + ".ServerSchedulerReportingWrapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPurpur() {
        try {
            Class.forName("org.purpurmc.purpur.PurpurConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isArclight() {
        try {
            Class.forName("io.izzel.arclight.server.Launcher");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isWaterfall() {
        try {
            Class.forName("io.github.waterfallmc.waterfall.conf.WaterfallConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isFlameCord() {
        try {
            Class.forName("dev._2lstudios.flamecord.configuration.FlameCordConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        nmsVersion = "N/A";
        spongeImplementations = new String[]{"\u00a7eSponge\u00a76Neo", "\u00a7eSponge\u00a76Forge", "\u00a7eSponge\u00a7fVanilla"};
    }

    public static enum Version {
        V1_0(22, 1321570800000L, "1.0.0/1"),
        V1_0_1(22, 1322089200000L, "1.0.0/1"),
        V1_1(23, 1326322800000L),
        V1_2_1(28, 1330556400000L, "1.2.1-1.2.3"),
        V1_2_2(28, 1330556400000L, "1.2.1-1.2.3"),
        V1_2_3(28, 1330642800000L, "1.2.1-1.2.3"),
        V1_2_4(29, 1332370800000L, "1.2.4/5"),
        V1_2_5(29, 1333490400000L, "1.2.4/5"),
        V1_3_1(39, 1343772000000L, "1.3.1/2"),
        V1_3_2(39, 1345068000000L, "1.3.1/2"),
        V1_4_2(47, 1351116000000L, "1.4.0-1.4.2"),
        V1_4_4(49, 1352847600000L, "1.4.4/5"),
        V1_4_5(49, 1353279600000L, "1.4.4/5"),
        V1_4_6(51, 1355958000000L, "1.4.6/7"),
        V1_4_7(51, 1357686000000L, "1.4.6/7"),
        V1_5(60, 1363129200000L, "1.5.0/1"),
        V1_5_1(60, 1363820400000L, "1.5.0/1"),
        V1_5_2(61, 1367445600000L),
        V1_6_1(73, 1372629600000L),
        V1_6_2(74, 1373234400000L),
        V1_6_4(78, 1379541600000L),
        V1_7_2(4, 1382652000000L, "1.7.2-1.7.5"),
        V1_7_4(4, 1386630000000L, "1.7.2-1.7.5"),
        V1_7_5(4, 1393369200000L, "1.7.2-1.7.5"),
        V1_7_6(5, 1396994400000L, "1.7.6-1.7.10"),
        V1_7_7(5, 1396994400000L, "1.7.6-1.7.10"),
        V1_7_8(5, 1397167200000L, "1.7.6-1.7.10"),
        V1_7_9(5, 1397426400000L, "1.7.6-1.7.10"),
        V1_7_10(5, 1403733600000L, "1.7.6-1.7.10"),
        V1_8(47, 1409608800000L, "1.8.x"),
        V1_8_1(47, 1416783600000L, "1.8.x"),
        V1_8_2(47, 1424300400000L, "1.8.x"),
        V1_8_3(47, 1424386800000L, "1.8.x"),
        V1_8_4(47, 1429221600000L, "1.8.x"),
        V1_8_5(47, 1432245600000L, "1.8.x"),
        V1_8_6(47, 1432504800000L, "1.8.x"),
        V1_8_7(47, 1433455200000L, "1.8.x"),
        V1_8_8(47, 1438034400000L, "1.8.x"),
        V1_8_9(47, 1449615600000L, "1.8.x"),
        V1_9(107, 1456700400000L),
        V1_9_1(108, 1459288800000L),
        V1_9_2(109, 1459288800000L),
        V1_9_3(110, 1462831200000L, "1.9.3/4"),
        V1_9_4(110, 1462831200000L, "1.9.3/4"),
        V1_10(210, 1465336800000L, "1.10.x"),
        V1_10_1(210, 1466546400000L, "1.10.x"),
        V1_10_2(210, 1466632800000L, "1.10.x"),
        V1_11(315, 1479078000000L),
        V1_11_1(316, 1482188400000L, "1.11.1/2"),
        V1_11_2(316, 1482274800000L, "1.11.1/2"),
        V1_12(335, 1496786400000L),
        V1_12_1(338, 1501711200000L),
        V1_12_2(340, 1505685600000L),
        V1_13(393, 1531864800000L),
        V1_13_1(401, 1534888800000L),
        V1_13_2(404, 1540159200000L),
        V1_14(477, 1555970400000L),
        V1_14_1(480, 1557698400000L),
        V1_14_2(485, 1558908000000L),
        V1_14_3(490, 1561327200000L),
        V1_14_4(498, 1563487200000L),
        V1_15(573, 1575932400000L),
        V1_15_1(575, 1576537200000L),
        V1_15_2(578, 1579561200000L),
        V1_16(735, 1592863200000L),
        V1_16_1(736, 1592949600000L),
        V1_16_2(751, 1597096800000L),
        V1_16_3(753, 1599688800000L),
        V1_16_4(754, 1604271600000L, "1.16.4/5"),
        V1_16_5(754, 1610665200000L, "1.16.4/5"),
        V1_17(755, 1623103200000L),
        V1_17_1(756, 1625522400000L),
        V1_18(757, 1638226800000L, "1.18.0/1"),
        V1_18_1(757, 1639090800000L, "1.18.0/1"),
        V1_18_2(758, 1646002800000L),
        V1_19(759, 1654552800000L),
        V1_19_1(760, 1658872800000L, "1.19.1/2"),
        V1_19_2(760, 1659650400000L, "1.19.1/2"),
        V1_19_3(761, 1670367600000L),
        V1_19_4(762, 1678748400000L),
        V1_20(763, 1686088800000L, "1.20.0/1"),
        V1_20_1(763, 1686520800000L, "1.20.0/1"),
        V1_20_2(764, 1695247200000L),
        V1_20_3(765, 1701730800000L, "1.20.3/4"),
        V1_20_4(765, 1701903600000L, "1.20.3/4"),
        V1_20_5(766, 1713823200000L, "1.20.5/6"),
        V1_20_6(766, 1714341600000L, "1.20.5/6"),
        V1_21(767, 1718229600000L, "1.21.0/1"),
        V1_21_1(767, 1723068000000L, "1.21.0/1"),
        V1_21_2(768, 1729548000000L, "1.21.2/3"),
        V1_21_3(768, 1729634400000L, "1.21.2/3"),
        V1_21_4(769, 1733180400000L),
        V1_21_5(770, 1742857200000L),
        V1_21_6(771, 1750111200000L),
        V1_21_7(772, 1751234400000L, "1.21.7/8"),
        V1_21_8(772, 1752703200000L, "1.21.7/8"),
        V1_21_9(773, 1759183200000L, "1.21.9/10"),
        V1_21_10(773, 1759788000000L, "1.21.9/10"),
        V1_21_11(774, 1765234800000L, "1.21.11"),
        UNSUPPORTED(-1, 0L);

        private int protocol;
        private long releaseDate;
        private String name;

        private Version(int protocol, long releaseDate) {
            this(protocol, releaseDate, null);
        }

        private Version(int protocol, long releaseDate, String name) {
            this.protocol = protocol;
            this.releaseDate = releaseDate;
            this.name = name;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public long getReleaseDate() {
            return this.releaseDate;
        }

        public String getName() {
            return this == UNSUPPORTED ? this.name() : (this.name == null ? (this.name = this.name().substring(1).replace('_', '.')) : this.name);
        }

        public boolean isPreNettyRewrite() {
            return this.ordinal() < 21;
        }

        public boolean isOlderThan(Version version) {
            return this.ordinal() < version.ordinal();
        }

        public boolean isAtLeast(Version version) {
            return !this.isOlderThan(version);
        }

        public String toString() {
            return this == UNSUPPORTED ? this.name() : this.name().substring(1).replace("_", ".");
        }

        public String format() {
            if (this == UNSUPPORTED) {
                return this.name();
            }
            String format = this.getName() == null ? this.toString() : this.getName();
            int dot = format.indexOf(46);
            return ConfigurationType.CONFIG.get().getBoolean("settings.truncate-version-string") && dot != -1 && format.indexOf(46, dot + 1) != -1 ? format.substring(0, format.indexOf(46, dot + 1)) : format;
        }

        public static Version getVersion(String input) {
            Version version = UNSUPPORTED;
            try {
                if (input.contains("/")) {
                    input = input.substring(0, input.indexOf(47));
                }
                if (input.endsWith(".0")) {
                    input = input.substring(0, input.lastIndexOf(46));
                }
            }
            catch (IndexOutOfBoundsException e) {
                return version;
            }
            for (Version value : Version.values()) {
                if (!input.equals(value.name().substring(1).replace('_', '.'))) continue;
                version = value;
                break;
            }
            return version;
        }

        public static Version getVersion(int protocol, boolean preNettyRewrite) {
            for (Version version : Version.values()) {
                if (preNettyRewrite != version.isPreNettyRewrite() || version.getProtocol() != protocol) continue;
                return version;
            }
            return UNSUPPORTED;
        }
    }
}

