/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;

public enum VersionChange {
    NULL,
    MAJOR_UPGRADE,
    MAJOR_DOWNGRADE,
    MINOR_UPGRADE,
    MINOR_DOWNGRADE,
    PATCH_UPGRADE,
    PATCH_DOWNGRADE,
    SNAPSHOT_UPGRADE,
    SNAPSHOT_DOWNGRADE;


    public int getIndex() {
        return (this.ordinal() + 1) / 2 - 1;
    }

    public boolean isSupported() {
        return !this.name().contains("DOWNGRADE");
    }

    public boolean isMajor() {
        return this.getIndex() == 0;
    }

    public boolean isMinor() {
        return this.getIndex() == 1;
    }

    public boolean isPatch() {
        return this.getIndex() == 2;
    }

    public boolean isSnapshot() {
        return this.getIndex() == 3;
    }

    public static VersionChange getVersionChange(String version, String newVersion) {
        if (!version.equals(newVersion)) {
            boolean snapshotUpgrade = false;
            if (version.endsWith("-SNAPSHOT")) {
                version = version.substring(0, version.lastIndexOf(45));
                snapshotUpgrade = true;
            }
            if (newVersion.endsWith("-SNAPSHOT")) {
                newVersion = newVersion.substring(0, newVersion.lastIndexOf(45));
            }
            String[] numbers = version.split("\\.");
            String[] newNumbers = newVersion.split("\\.");
            for (int i = 0; i < 3; ++i) {
                if (numbers[i].equals(newNumbers[i])) continue;
                return VersionChange.getVersionChange(i, Integer.valueOf(newNumbers[i]) > Integer.valueOf(numbers[i]));
            }
            return snapshotUpgrade ? SNAPSHOT_UPGRADE : SNAPSHOT_DOWNGRADE;
        }
        return NULL;
    }

    private static VersionChange getVersionChange(int index, boolean upgrade) {
        for (VersionChange versionChange : VersionChange.values()) {
            if (index != versionChange.getIndex() || !(upgrade ? versionChange.isSupported() : !versionChange.isSupported())) continue;
            return versionChange;
        }
        return NULL;
    }

    public static VersionChange getVersionChange(Configuration configuration, String path, String newVersion) {
        return VersionChange.getVersionChange(configuration.getString(path, "0.0.1"), newVersion);
    }
}

